/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: turnoff.h,v 1.2 1999/11/16 18:25:53 stef Exp $
*/

#ifndef __qm_turnoff_h__
#define __qm_turnoff_h__

#include <quasimodo/opcode_defs.h>

OpcodeArgument(TURNOFF)
        Number	*out;
        Number	*in, *duration, *threshold, *enabled;
		Number	sum;
		int		num_samples;
};

extern void turnoff_set(TURNOFF*);
extern void turnoff_audio(TURNOFF*);

#define TURNOFF_OPCODE_LIST \
{\
	"turnoff", S(TURNOFF), InitTime|EventTime|AudioTime, "a", "aXXX", \
	  F(turnoff_set), NULL, F(turnoff_audio)\
}

#endif // __qm_turnoff_h__
