#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/dsp.h>
#include <quasimodo/process.h>
#include <quasimodo/module_set.h>

#include "turnoff.h"

void
turnoff_set(TURNOFF* p)
{
	p->sum=0;
	p->num_samples = 0;
}


void
turnoff_audio(TURNOFF* p)
{
	Number sum = p->sum;
	Number *in = p->in;
	Number *out = p->out;

	if(!*p->enabled) {
		for (size_t i=0; i<ksmps; ++i) {
			*out++ = *in++;
		}
		return;
	}

		
	for (size_t i = 0; i < ksmps; ++i) {
		sum += (*in * *in);
		*out++ = *in++;
	}
	p->sum = sum;
	p->num_samples+=ksmps;


	if( (p->num_samples / esr) > *p->duration) {
		if(p->sum/p->num_samples < ( *p->threshold * *p->threshold) ) {
			p->PROCESS->module()->module_set()->turnoff();
		}
		else {
			p->sum=0;
			p->num_samples=0;
		}
	}

	
}


Opcode opcodes[] = 

{
	TURNOFF_OPCODE_LIST,
	{ NULL }
};
