/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: trigwait.h,v 1.1 1999/11/01 04:25:04 pbd Exp $
*/

#include <quasimodo/opcode_defs.h>

OpcodeArgument(TRIGGER)
       Number *ptr;
       Number *val;
};

OpcodeArgument(TRIGGER_DELTA)
       Number *ptr;
       Number lastval;
};

void trigwait_init (TRIGGER_DELTA *);
void trigwait      (TRIGGER_DELTA *);
void trigwait_lt   (TRIGGER *);
void trigwait_lteq (TRIGGER *);
void trigwait_gt   (TRIGGER *);
void trigwait_gteq (TRIGGER *);
void trigwait_eq   (TRIGGER *);
void trigwait_neq  (TRIGGER *);

#define TRIGWAIT_OPCODE_LIST \
	{"trigwait", S(TRIGGER), InitTime|EventTime, "", "k",  \
	 F(trigwait_init), F(trigwait), NULL }, \
	{"trigwaitlt", S(TRIGGER), EventTime, "", "kX",  \
	 NULL, F(trigwait_lt), NULL }, \
	{"trigwaitlteq", S(TRIGGER), EventTime, "", "kX", \
	 NULL, F(trigwait_lteq), NULL }, \
	{"trigwaitgt", S(TRIGGER), EventTime, "", "kX", \
	 NULL, F(trigwait_gt), NULL }, \
	{"trigwaitgteq", S(TRIGGER), EventTime, "", "kX", \
	 NULL, F(trigwait_gteq), NULL }, \
	{"trigwaiteq", S(TRIGGER), EventTime, "", "kX", \
	 NULL, F(trigwait_eq), NULL }, \
	{"trigwaitneq", S(TRIGGER), EventTime, "", "kX", \
	 NULL, F(trigwait_neq), NULL }
