/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: timeops.h,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#ifndef __qm_timeops_h__
#define __qm_timeops_h__

#include <quasimodo/opcode_defs.h>
				
OpcodeArgument(REL)
	Number  *r;
};

OpcodeArgument(XTRADUR)
	Number  *extradur;
};

#define DEFAULT_XTRADUR 1

OpcodeArgument(RDTIME)
	Number 	*rslt;
	int32	instartk;
};

extern void ihold(BASIC_OP_ARG *);
extern void turnoff (BASIC_OP_ARG *);
extern void xtratim (XTRADUR *);
extern void release_set (REL *p);
extern void release (REL *p);
extern void timek (RDTIME *p);
extern void timesr (RDTIME *p);
extern void instimset (RDTIME *p);
extern void instimek (RDTIME *p);
extern void instimes (RDTIME *p);

#define TIMEOPS_OPCODE_LIST \
{"ihold", S(BASIC_OP_ARG), InitTime, "", "", F(ihold), NULL, NULL}, \
{"xtratim", S(XTRADUR), InitTime, "", "i", F(xtratim), NULL, NULL}, \
/* synonym */ \
{"extratime", S(XTRADUR), InitTime, "", "i", F(xtratim), NULL, NULL}, \
{"release", S(REL), InitTime|EventTime, "k", "", \
	 F(release_set), F(release), NULL}, \
{"timek_i", S(RDTIME), InitTime, "i", "", F(timek), NULL, NULL}, \
{"times_i", S(RDTIME), InitTime, "i", "", F(timesr), NULL, NULL}, \
{"timek", S(RDTIME), EventTime, "k", "", NULL, F(timek), NULL}, \
{"times", S(RDTIME), EventTime, "k", "", NULL, F(timesr), NULL}, \
{"timeinstk", S(RDTIME), EventTime, "k", "", NULL, F(instimek), NULL}, \
{"timeinsts", S(RDTIME), EventTime, "k", "", NULL, F(instimes), NULL}


#endif __qm_timeops_h__
