/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: timeops.cc,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/


#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/process.h>
#include <quasimodo/qm_time.h>
#include <quasimodo/dsp.h>
#include <quasimodo/dspstat.h>

#include "timeops.h"

void
xtratim(XTRADUR * p)
{
	p->PROCESS->extra_time = (qm_time_t) (*p->extradur * esr);
}

void
release_set(REL * p)
{
	if (p->PROCESS->extra_time < DEFAULT_XTRADUR) {
		/* if not initialized by another opcode */
		p->PROCESS->extra_time = DEFAULT_XTRADUR;
	}
}

void
release(REL * p)
{
	if (p->PROCESS->releasing()) {
		*p->r = 1;
	} else {
		*p->r = 0;
	}
}

void
ihold (BASIC_OP_ARG * p)
{				
	/* make this note indefinit duration
	   called by ihold statmnt at Itime.
	   no-op at reinit
	*/

	if (!p->PROCESS->reinitializing()) {	
		p->PROCESS->hold();
	}
}


/*****************************************************************************/

/* Subroutines for reading absolute time. */

/* timek()
 *
 * Called at i rate or k rate, by timek, itimek, timesr or itemes.
 */

void
timek (RDTIME * p)
{
	*p->rslt = (Number) dsp->cycle();
}

/* timesr() */
void
timesr (RDTIME * p)
{
	*p->rslt = (Number) dsp_real_secs;
}

/*-----------------------------------*/

/* Subroutines to read time for this instance of the module. */

void
instimek(RDTIME * p)
{
	*p->rslt = (Number) (dsp->audio_time() -
			    p->PROCESS->time_on()) * onedkr;
}

void
instimes(RDTIME * p)
{
	*p->rslt = ((Number) (dsp->audio_time() - p->PROCESS->time_on()))/esr;
}


Opcode opcodes[] = 
{
	TIMEOPS_OPCODE_LIST,
	{ NULL }
};
