#ifndef __qm_svfilter_h__
#define __qm_svfilter_h__

/* svfilter.h
 *
 * Copyright 1999, by Sean M. Costello
 *
 * svfilter is an implementation of Hal Chamberlin's state variable filter 
 * algorithm, from "Musical Applications of Microprocessors" (Hayden Books,
 * Indianapolis, Indiana, 1985), 2nd. edition, pp. 489-492. It implements
 * a second-order resonant filter, with lowpass, highpass and bandpass
 * outputs.
 *
 */

#include <quasimodo/opcode_defs.h>

OpcodeArgument(SVF)
        Number *low, *high, *band, *in, *kfco, *kq, *iscl;
        Number ynm1, ynm2;
};

void svfset (SVF *);
void svf    (SVF *);

#define SVFILTER_OPCODE_LIST \
{ "svfilter", S(SVF), InitTime|AudioTime, "aaa", "akko", \
      F(svfset), NULL, F(svf) }

#endif __qm_svfilter_h__
