/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: spatializer2D.cc,v 1.1 1999/11/17 09:33:25 stef Exp $
*/

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <math.h>

#include "spatializer2D.h"

void
spatializer2Dset(SPATIALIZER2D* p)
{
  p->_sample = 0;
}


void
spatializer2Da(SPATIALIZER2D* p)
{
  Number *aleft = p->aleft, *aright = p->aright;
  Number *in = p->ain;

  Number d = sqrt(2*(1 + *p->xpos * *p->xpos));
  p->_left = (1+*p->xpos) / d;
  p->_right = (1-*p->xpos) / d;	
  double dist = (1-*p->zpos);
  dist *= dist;
  p->_a = dist * (1-*p->zpos);
  p->_b = dist * *p->zpos;

  int nbsamp = ksmps;
	do {
		p->_sample = p->_a * *in++ + p->_b * p->_sample;		
		*aleft++ = p->_sample * p->_left;
		*aright++ = p->_sample * p->_right;
	} while(--nbsamp);

}

Opcode opcodes[] = 
{
	SPATIALIZER2D_OPCODE_LIST,
	{ NULL }
};

