/*
    Copyright (C) 1999 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: soundio.cc,v 1.3 1999/12/18 18:24:27 pbd Exp $
*/

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_defs.h>
#include <quasimodo/audio.h>
#include "soundio.h"

void
in(IN * p)
{
	sample_t *sp, *ar;
	size_t nFrames = CycleFrames;

	sp = audio_input_buffer;
	ar = p->ar;
	do
		*ar++ = *sp++;
	while (--nFrames);
}

void
ins(INS * p)
{
	sample_t *sp, *ar1, *ar2;
	size_t nFrames = CycleFrames;

	sp = audio_input_buffer;
	ar1 = p->ar1;
	ar2 = p->ar2;

	do {
		*ar1++ = *sp++;
		*ar2++ = *sp++;
	}
	while (--nFrames);
}

void
inq(INQ * p)
{
	sample_t *sp, *ar1, *ar2, *ar3, *ar4;
	size_t nFrames = CycleFrames;

	sp = audio_input_buffer;
	ar1 = p->ar1;
	ar2 = p->ar2;
	ar3 = p->ar3;
	ar4 = p->ar4;
	do {
		*ar1++ = *sp++;
		*ar2++ = *sp++;
		*ar3++ = *sp++;
		*ar4++ = *sp++;
	}
	while (--nFrames);
}

void
inh(INH * p)
{
	sample_t *sp, *ar1, *ar2, *ar3, *ar4, *ar5, *ar6;
	size_t nFrames = CycleFrames;

	sp = audio_input_buffer;
	ar1 = p->ar1;
	ar2 = p->ar2;
	ar3 = p->ar3;
	ar4 = p->ar4;
	ar5 = p->ar5;
	ar6 = p->ar6;
	do {
		*ar1++ = *sp++;
		*ar2++ = *sp++;
		*ar3++ = *sp++;
		*ar4++ = *sp++;
		*ar5++ = *sp++;
		*ar6++ = *sp++;
	}
	while (--nFrames);
}

void
ino(INO * p)
{
	sample_t *sp, *ar1, *ar2, *ar3, *ar4, *ar5, *ar6, *ar7, *ar8;
	size_t nFrames = CycleFrames;

	sp = audio_input_buffer;
	ar1 = p->ar1;
	ar2 = p->ar2;
	ar3 = p->ar3;
	ar4 = p->ar4;
	ar5 = p->ar5;
	ar6 = p->ar6;
	ar7 = p->ar7;
	ar8 = p->ar8;
	do {
		*ar1++ = *sp++;
		*ar2++ = *sp++;
		*ar3++ = *sp++;
		*ar4++ = *sp++;
		*ar5++ = *sp++;
		*ar6++ = *sp++;
		*ar7++ = *sp++;
		*ar8++ = *sp++;
	}
	while (--nFrames);
}

void
out(OUT * p)
{
	sample_t *sp, *ap;
	size_t nFrames = CycleFrames;

	ap = p->asig;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp++ = *ap++;
		} while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *ap++;
			sp++;
		}
		while (--nFrames);
	}
}

void
outs(OUTS * p)
{
	sample_t *sp, *sigleft, *sigright;
	size_t nFrames = CycleFrames;

	sigleft = p->asig1;
	sigright = p->asig2;
	sp = audio_output_buffer;

	if (!audio_output_pending) {
		do {
			*sp++ = *sigleft++;
			*sp++ = *sigright++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *sigleft++;
			sp++;
			*sp += *sigright++;
			sp++;
		}
		while (--nFrames);
	}
}

void
outq(OUTQ * p)
{
	sample_t *sp, *sigp1, *sigp2, *sigp3, *sigp4;
	size_t nFrames = CycleFrames;

	sigp1 = p->asig1;
	sigp2 = p->asig2;
	sigp3 = p->asig3;
	sigp4 = p->asig4;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp = *sigp1++;
			sp++;
			*sp = *sigp2++;
			sp++;
			*sp = *sigp3++;
			sp++;
			*sp = *sigp4++;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *sigp1++;
			sp++;
			*sp += *sigp2++;
			sp++;
			*sp += *sigp3++;
			sp++;
			*sp += *sigp4++;
			sp++;
		}
		while (--nFrames);
	}
}

void
outs1(OUT * p)
{
	sample_t *sp, *sigp1;
	size_t nFrames = CycleFrames;

	sigp1 = p->asig;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp = *sigp1++;
			sp++;
			*sp = FZERO;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *sigp1++;
			sp += 2;
		}
		while (--nFrames);
	}
}

void
outs2(OUT * p)
{
	sample_t *sp, *sigp2;
	size_t nFrames = CycleFrames;

	sigp2 = p->asig;
	if (!audio_output_pending) {
		sp = audio_output_buffer;
		do {
			*sp = FZERO;
			sp++;
			*sp = *sigp2++;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		sp = audio_output_buffer + 1;
		do {
			*sp += *sigp2++;
			sp += 2;
		}
		while (--nFrames);
	}
}

void
outs12(OUT * p)
{
	sample_t *sp, *ap;
	size_t nFrames = CycleFrames;

	ap = p->asig;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp++ = *ap;
			*sp++ = *ap++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *ap;
			sp++;
			*sp += *ap++;
			sp++;
		}
		while (--nFrames);
	}
}

void
outq1(OUT * p)
{
	sample_t *sp, *sigp1;
	size_t nFrames = CycleFrames;

	sigp1 = p->asig;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp = *sigp1++;
			sp++;
			*sp = FZERO;
			sp++;
			*sp = FZERO;
			sp++;
			*sp = FZERO;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *sigp1++;
			sp += 4;
		}
		while (--nFrames);
	}
}

void
outq2(OUT * p)
{
	sample_t *sp, *sigp2;
	size_t nFrames = CycleFrames;

	sigp2 = p->asig;
	if (!audio_output_pending) {
		sp = audio_output_buffer;
		do {
			*sp = FZERO;
			sp++;
			*sp = *sigp2++;
			sp++;
			*sp = FZERO;
			sp++;
			*sp = FZERO;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		sp = audio_output_buffer + 1;
		do {
			*sp += *sigp2++;
			sp += 4;
		}
		while (--nFrames);
	}
}

void
outq3(OUT * p)
{
	sample_t *sp, *sigp3;
	size_t nFrames = CycleFrames;

	sigp3 = p->asig;
	if (!audio_output_pending) {
		sp = audio_output_buffer;
		do {
			*sp = FZERO;
			sp++;
			*sp = FZERO;
			sp++;
			*sp = *sigp3++;
			sp++;
			*sp = FZERO;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		sp = audio_output_buffer + 2;
		do {
			*sp += *sigp3++;
			sp += 4;
		}
		while (--nFrames);
	}
}

void
outq4(OUT * p)
{
	sample_t *sp, *sigp4;
	size_t nFrames = CycleFrames;

	sigp4 = p->asig;
	if (!audio_output_pending) {
		sp = audio_output_buffer;
		do {
			*sp = FZERO;
			sp++;
			*sp = FZERO;
			sp++;
			*sp = FZERO;
			sp++;
			*sp = *sigp4++;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		sp = audio_output_buffer + 3;
		do {
			*sp += *sigp4++;
			sp += 4;
		}
		while (--nFrames);
	}
}

void
outh(OUTH * p)
{
	sample_t *sp, *sigp1, *sigp2, *sigp3, *sigp4, *sigp5, *sigp6;
	size_t nFrames = CycleFrames;

	sigp1 = p->asig1;
	sigp2 = p->asig2;
	sigp3 = p->asig3;
	sigp4 = p->asig4;
	sigp5 = p->asig5;
	sigp6 = p->asig6;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp = *sigp1++;
			sp++;
			*sp = *sigp2++;
			sp++;
			*sp = *sigp3++;
			sp++;
			*sp = *sigp4++;
			sp++;
			*sp = *sigp5++;
			sp++;
			*sp = *sigp6++;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *sigp1++;
			sp++;
			*sp += *sigp2++;
			sp++;
			*sp += *sigp3++;
			sp++;
			*sp += *sigp4++;
			sp++;
			*sp += *sigp5++;
			sp++;
			*sp += *sigp6++;
			sp++;
		}
		while (--nFrames);
	}
}

void
outo(OUTO * p)
{
	sample_t *sp, *sigp1, *sigp2, *sigp3, *sigp4, *sigp5, *sigp6, *sigp7, *sigp8;
	size_t nFrames = CycleFrames;

	sigp1 = p->asig1;
	sigp2 = p->asig2;
	sigp3 = p->asig3;
	sigp4 = p->asig4;
	sigp5 = p->asig5;
	sigp6 = p->asig6;
	sigp7 = p->asig7;
	sigp8 = p->asig8;
	sp = audio_output_buffer;
	if (!audio_output_pending) {
		do {
			*sp = *sigp1++;
			sp++;
			*sp = *sigp2++;
			sp++;
			*sp = *sigp3++;
			sp++;
			*sp = *sigp4++;
			sp++;
			*sp = *sigp5++;
			sp++;
			*sp = *sigp6++;
			sp++;
			*sp = *sigp7++;
			sp++;
			*sp = *sigp8++;
			sp++;
		}
		while (--nFrames);
		audio_output_pending = 1;
	} else {
		do {
			*sp += *sigp1++;
			sp++;
			*sp += *sigp2++;
			sp++;
			*sp += *sigp3++;
			sp++;
			*sp += *sigp4++;
			sp++;
			*sp += *sigp5++;
			sp++;
			*sp += *sigp6++;
			sp++;
			*sp += *sigp7++;
			sp++;
			*sp += *sigp8++;
			sp++;
		}
		while (--nFrames);
	}
}

Opcode opcodes[] = {
	SOUNDIO_OPCODE_LIST
	{ NULL }
};

