/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: soundin.h,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#ifndef __qm_soundin_h__
#define __qm_soundin_h__

#include <pbd/rcpointer.h>
#include <soundfile/soundfile.h>

#include <quasimodo/opcode_defs.h>

OpcodeArgument(SOUNDIN)
        Number   *chan[32];
        Number   *ifilno, *iskptim, *iformat, *loop;
        RCPointer<SoundFile> sf;
        size_t nchannels;
	bool *channel_mask;
        bool atend;
        size_t current_frame;
};

extern int sndgetset (SOUNDIN *p);
extern void sndinset (SOUNDIN *p);
extern void soundin  (SOUNDIN *p);

#define SOUNDIN_OPCODE_LIST \
{ "soundin",S(SOUNDIN),	InitTime|AudioTime, \
     "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy","Sooo", \
	  F(sndinset), NULL, F(soundin) }, \
{ "soundin",S(SOUNDIN),	InitTime|AudioTime, \
     "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy","iooo", \
	  F(sndinset), NULL, F(soundin) }

#endif __qm_soundin_h__

