/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: soundin.cc,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include <quasimodo/qm.h>
#include <quasimodo/initerror.h>
#include <quasimodo/opcode.h>
#include <quasimodo/dsp.h>
#include <quasimodo/quasimodo.h>
#include <quasimodo/qm_soundfile.h>
#include <quasimodo/process.h>

#include "soundin.h"

int
sndgetset(SOUNDIN *p)

{				
	size_t n;
	char sound_path[PATH_MAX+1];
	RCPointer<SoundFile> sf;

	p->nchannels = p->OUTOCOUNT;

	if (is_string_ptr (p->ifilno)) {
		strcpy (sound_path, get_string(p->ifilno));
	} else {
		sprintf(sound_path, "soundin.%ld", (long) *p->ifilno);
	}

	sf = soundfiles->open (sound_path);

	if (sf == 0) {
		error << "soundin: cannot open or grok sound file " << sound_path << endmsg;

		return -1;
	}
	
	p->current_frame = (long) (*p->iskptim * sf->sample_rate());
	p->atend = false;
	p->channel_mask = new bool[sf->channels()];

	for (n = 0; n < sf->channels(); n++) {
		p->channel_mask[n] = true;
	}

	if (sf->channels() > p->nchannels) {
		warning << "soundin: input file " << sf->short_name () << " has " << sf->channels() << " channels "
			 "(only first " << p->nchannels << " used)" << endmsg;


		for (n = p->nchannels; n < sf->channels(); n++) {
			p->channel_mask[n] = false;
		}
		
	} else if (sf->channels() < p->nchannels) {
		warning << "soundin: input file " << sf->short_name() << " has only " << sf->channels() << " channels, not " << p->nchannels << endmsg;


		/* no need to do anything special */
	}

	p->sf = sf;

	return 0;
}

void
sndinset(SOUNDIN * p)
{
	InitError err;

	if (sndgetset (p)) { 
		err << "soundin: bad soundfile" << endmsg;
	}
}

void
soundin(SOUNDIN * p)
{
	size_t nread;

	nread = p->sf->read (p->current_frame, p->chan, ksmps, 
			     0, p->channel_mask, &p->atend);

	if (nread < 0) {
		p->error ("soundin: read failed on %s "
			       "in frame range %d-%d",
			       p->sf->short_name(),
			       p->current_frame,
			       p->current_frame + ksmps);
	}

	p->current_frame += nread;

	if (p->atend) {
		if (*p->loop) {
			p->current_frame = 0;
		} else {
			p->PROCESS->turnoff ();
		}
	}


}	

Opcode opcodes[] = 

{
	SOUNDIN_OPCODE_LIST,
	{ NULL }
};


