#ifndef __physmod_singwave_h__
#define __physmod_singwave_h__

#include <quasimodo/opcode_defs.h>
#include "moog1.h"

/*******************************************/
/*  "Singing" Looped Soundfile Class,      */
/*  by Perry R. Cook, 1995-96              */ 
/*  This Object contains all that's needed */
/*  to make a pitched musical sound, like  */
/*  a simple voice or violin.  In general, */  
/*  it will not be used alone (because of  */
/*  of munchinification effects from pitch */
/*  shifting.  It will be used as an       */
/*  excitation source for other instruments*/
/*******************************************/

extern Number phonGains[32][2];
extern Number phonParams[32][4][3];
extern char phonemes[32][4];

/*******************************************/
/*  Modulator Class, Perry R. Cook, 1995-96*/ 
/*  This Object combines random and        */
/*  periodic modulations to give a nice    */
/*  natural human modulation function.     */  
/*******************************************/

typedef struct SubNoise
{
     Noise	lastOutput;
     int32	counter;
     int32	howOften;
} SubNoise;

/* void make_SubNoise(SubNoise *); */
void make_SubNoise(SubNoise *, int32 subSample);
void SubNoise_setHowOften(SubNoise *, int32 howOft);
Number SubNoise_tick(SubNoise *);

typedef struct Modulatr {
    RCPointer<FunctionTable>	wave;
    Number    v_rate;
    Number    v_time;
    Number    v_phase;
    Number    v_lastOutput;
    SubNoise noise;
    OnePole  onepole;
    Number    vibAmt;
/*     Number    rndAmt; */
    Number    lastOutput;
} Modulatr;

void make_Modulatr(Modulatr *, Number *);
void Modulatr_reset(Modulatr *);
void Modulatr_setRndAmt(Modulatr *, Number rndAmount);
Number Modulatr_tick(Modulatr *);
Number Modulatr_lastOut(Modulatr *);

typedef struct SingWave {
    Modulatr	modulator;
    Envelope	envelope;
    Envelope	pitchEnvelope;
    RCPointer<FunctionTable>	wave;
    Number	rate;
    Number	sweepRate;
    Number	mytime;
    Number	lastOutput;
} SingWave;

void make_SingWave(SingWave *, Number *, Number *);
void SingWave_reset(SingWave *);
void SingWave_setFreq(SingWave *,Number aFreq);    
Number SingWave_tick(SingWave *);
void SingWave_print(SingWave *);

/*******************************************/
/*  4 Formant Synthesis Module         */
/*  by Perry R. Cook, 1995-96              */ 
/*  This module contains an excitation */
/*  singing wavetable (looping wave with   */
/*  random and periodic vibrato, smoothing */
/*  on frequency, etc.), excitation noise, */
/*  and four sweepable complex resonances. */
/*					   */
/*  Measured Formant data (from me) is     */
/*  included, and enough data is there to  */
/*  support either parallel or cascade     */
/*  synthesis.  In the Numbering point case */
/*  cascade synthesis is the most natural  */
/*  so that's what you'll find here.       */
/*					   */
/*  For right now, there's a simple command*/
/*  line score interface consisting of 3   */
/*  letter symbols for the phonemes, =xx   */
/*  sets the pitch to x, + and - add and   */
/*  subtract a half step, and ... makes it */
/*  keep doing what it's doing for longer. */
/*******************************************/

OpcodeArgument(VOICF)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*phoneme, *formant;
    Number	*vibf, *vibAmt;
    Number	*ifn, *ivfn;

    Number	oldform;
    int32		ph;
    Number	basef;
    SingWave	voiced;
    Noise	noise;
    Envelope	noiseEnv;
    FormSwep    filters[4];
    OnePole	onepole;
    OneZero	onezero;
};

void make_VoicForm(VOICF*);
void VoicForm_clear(VOICF*);
void VoicForm_setPhoneme(VOICF*, int32 i, Number s);
void VoicForm_setVoicedUnVoiced(VOICF*, Number vGain, Number nGain);
void VoicForm_noteOn(VOICF*, Number freq, Number amp);
void VoicForm_noteOff(VOICF*);

extern void OneZero_setCoeff (OneZero *, Number);
extern Number Wave_tick (Number *, int32, Number *, Number, Number);
extern void make_SubNoise (SubNoise *p, int32 subSample);
extern Number SubNoise_tick (SubNoise *p);
extern void make_Modulatr (Modulatr *p, Number *i);
extern Number Modulatr_tick (Modulatr *p);
extern void Modulatr_print (Modulatr *p);
extern void make_SingWave (SingWave *p, Number *ifn, Number *ivfn);
extern void SingWave_setFreq (SingWave *p, Number aFreq);
extern Number SingWave_tick (SingWave *p);
extern void SingWave_print (SingWave *p);
extern void VoicForm_setPhoneme (VOICF *p, int32 i, Number sc);
extern void VoicForm_setVoicedUnVoiced (VOICF *p, Number vGain, Number nGain);
extern void VoicForm_quiet (VOICF *p);
extern void VoicForm_noteOff (VOICF *p);
extern void voicprint (VOICF *p);
extern void voicformset (VOICF *p);
extern void voicform (VOICF *p);

#define SINGWAVE_OPCODE_LIST \
{"voice", S(VOICF), InitTime|AudioTime, "a", "kkkkkkii", \
	 F(voicformset), NULL, F(voicform), 0, "physutil" }

#endif __physmod_singwave_h__

