#ifndef __physmod_shaker_h__
#define __physmod_shaker_h__

/******************************************/  
/*  Maracha (& other shakers) Simulation  */
/*  by Perry R. Cook, 1996		  */
/*  by Perry Cook, 1995-96                */
/*                                        */
/*  See ICMC96 paper "PhISM: Percussive   */
/*  Synthesis." for more exciting details */
/******************************************/

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

OpcodeArgument(SHAKER)
    Number	*ar;                  /* Output */
    Number	*amp, *kfreq;
    Number	*beancount, *shake_damp;
    Number	*times, *dettack;

    BiQuad	filter;
    ADSR	envelope;
    int32	num_beans;
    int32	wait_time;
    int32	shake_num;
    Number	shake_speed;    /* A + amp*N -- hides two parameters */
    Number	res_freq;
    Number	coll_damp;
    Number	shakeEnergy;
    Number	noiseGain;
    Number	gain_norm;
    int32	kloop;
    Number      freq;
};

extern void shakerset (SHAKER *p);
extern void shaker (SHAKER *p);

#define SHAKER_OPCODE_LIST \
{"shaker", S(SHAKER), InitTime|AudioTime, "a", "kkkkko", \
	 F(shakerset), NULL, F(shaker), 0, "physutil" }

#endif __physmod_shaker_h__

