/*
    Copyright (C) 1998-99 Paul Barton-Davis
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: sendsig.cc,v 1.3 1999/12/15 19:41:40 pbd Exp $
*/

#include <math.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_enums.h>
#include <quasimodo/process.h>
#include <quasimodo/module.h>
#include <quasimodo/module_interface.h>

#include "sendsig.h"

void
sendsiginit (SENDSIG *p)

{
	const char *sinkname;
	ModuleInterface *mi;

	if (!is_string_ptr (p->sinkname)) {
		p->error ("sendsig: 1st argument not a string");
	}

	sinkname = get_string (p->sinkname);

	if ((mi = p->MODULE->interface ()) == 0) {
		p->error ("module has no interface!");
	}

	p->sink = mi->sink (get_string (p->sinkname));

	if (p->sink == NULL) {
		p->error ("sendsig: no such signal sink \"%s\"", sinkname);
	}
}

void
sendsig (SENDSIG *p)

{
	if (p->has_audio_arguments()) {
		p->sink->add_signal (CycleFrames, p->source);
	} else {
		p->sink->add_signal (1, p->source);
	}
}

Opcode opcodes[] =
{
	SENDSIG_OPCODE_LIST,
	{ NULL }
};
