/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: rtsin.h,v 1.3 1999/12/20 17:17:35 stef Exp $
*/

#ifndef __qm_rtsin_h__
#define __qm_rtsin_h__

#include <quasimodo/opcode_defs.h>

/*
(c) 3.10.1997 by Tim Bscke
and Nao
http://members.xoom.com/amiga/sintables.html
*/

OpcodeArgument(RTSIN)
        Number   *ar;
        Number   *freq, *amp;
		Number a,b;
};


extern void rtsinset (RTSIN *p);
extern void rtsink  (RTSIN *p);
extern void rtsina  (RTSIN *p);

extern void rtsin_fm_audio (RTSIN *p);


#define RTSIN_OPCODE_LIST \
{\
	"rtsin", S(RTSIN), InitTime|EventTime|AudioTime, "s", "XX", \
	  F(rtsinset), F(rtsink), F(rtsina)\
}, \
{\
	"rtsinfm", S(RTSIN), InitTime|AudioTime, "a", "aa", \
	  F(rtsinset), NULL, F(rtsin_fm_audio)\
}



#endif //  __qm_rtsin_h__
