/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: rtsin.cc,v 1.3 1999/12/20 17:17:35 stef Exp $
*/

/*
(c) 3.10.1997 by Tim Bscke
and Nao
http://members.xoom.com/amiga/sintables.html
*/

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>

#include "rtsin.h"

void
rtsinset(RTSIN* p)
{
	p->a=0;
	p->b=1;
}

void
rtsink(RTSIN* p)
{
	const Number reald=1./10;
	Number d = (2 * M_PI  + reald ) * *p->freq / ekr;
	*p->ar  = p->a * *p->amp;
	p->a += p->b * d;
	p->b = p->b - d * p->a;
}


void
rtsina(RTSIN* p)
{
	Number a=p->a, b=p->b, *ar=p->ar;
	Number na=a,nb=b;

	const Number reald=1./100;
	Number d = (2 * M_PI  + reald ) * *p->freq / esr; 
	
	const Number amp = *p->amp;
	int nbsamp = ksmps;
	
	do {
		*ar++= a * amp;
		na = a + b * d;
		nb = b - d * na;
		a=na;
		b=nb;
	} while(--nbsamp);

	p->a = na;
	p->b = nb;
}


void
rtsin_fm_audio(RTSIN* p)
{
	Number a=p->a, b=p->b, *ar=p->ar;
	Number na=a,nb=b;

	const Number reald=1./10;
	Number d = (2 * M_PI  + reald ) / esr;
	
	const Number * amp = p->amp;
	const Number * freq = p->freq;
//	const Number amp = 32000;
//	const Number freq = 440;
	int nbsamp = ksmps;

	do {
		*ar++= a * (*amp++);
		na = a + b * d * *freq;
		nb = b - d * (*freq++) * na;
//		*ar++= a * (amp);
//		na = a + b * d * freq;
//		nb = b - d * (freq) * na;
		a=na;
		b=nb;
	} while(--nbsamp);

	p->a = na;
	p->b = nb;
}


Opcode opcodes[] = 

{
	RTSIN_OPCODE_LIST,
	{ NULL }
};

