/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: rtline.cc,v 1.1 1999/11/18 10:53:41 stef Exp $
*/


#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>

#include "rtline.h"

void
rtlineset(RTLINE* p)
{
	p->a=*p->start;
	p->inc=0;
	p->lastdur=0;
	p->count=0;
}


void
rtlinek(RTLINE* p)
{
	*p->kout = p->a;

	if(p->lastdur != *p->duration) { // if duration has changed
		p->count = *p->duration * (ekr);
		p->lastdur = *p->duration;
	}

	if(p->count != 0)
		p->inc = (*p->target - p->a) / p->count; // compute each ktime because p->target could have changed
	else {
//		cerr << "timeout !" << endl;
		return;
	}

	p->a += p->inc;
	(p->count)--;
	
	if(p->inc < 0) {
		if(p->a < *p->target)
			p->a = *p->target;
	}
	else {
		if(p->a > *p->target)
			p->a = *p->target;
	}
}


Opcode opcodes[] = 

{
	RTLINE_OPCODE_LIST,
	{ NULL }
};

