/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: reset.cc,v 1.2 1999/11/02 23:50:02 pbd Exp $
*/

/* These opcodes are equivalent to '=', but they will only have an 
   effect once per iteration of the DSP main loop. Because of this,
   they be used by instruments that may have multiple processes running
   and writing to a common location - the module may `reset' the
   common location at the top of its execution, and know that this
   will only be done once per DSP main loop (i.e. once per iteration
   of *all* of its instantiating processes).
*/

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/reset.h>
#include <quasimodo/dsp.h>
#include <quasimodo/module.h>

void
reset_init (RESET *p)

{
	p->last_reset = &(p->MODULE->infoptr (p->r)->last_reset);
}

void
reset_scalar (RESET *p)

{
	if (*p->last_reset < dsp->cycle()) {
		*p->r = *p->v;
		*p->last_reset = dsp->cycle();
	}
}

void
reset_vector (RESET *p)

{
	size_t nsmps = ksmps;
	Number *r;
	Number *v;

	r = p->r;
	v = p->v;

	if (*p->last_reset < dsp->cycle()) {
		if (p->nth_arg_is_audio (1)) {
			do {
				*r++ = *v++;
			} while (--nsmps);
		} else {
			do {
				*r++ = *v;
			} while (--nsmps);
		}

		*p->last_reset = dsp->cycle ();
	}
}

Opcode opcodes[] = {
	RESET_OPCODES_LIST,
	{ NULL }
};


