/*
    Code based on ideas by Robin Whittle and Gabriel Maldonado

    Copyright (C) 1998-99 Paul Barton-Davis
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: printk.cc,v 1.5 1999/12/18 18:24:27 pbd Exp $
*/


#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/process.h>
#include <quasimodo/module.h>
#include <quasimodo/dsp.h>
#include <quasimodo/dspstat.h>

#include "printk.h"

void
printmsg(TEXTMSG *p)

{
	int i;
	const char *str;

	for (i = 0; i < TEXTMSG_MAXARGS; i++) {
		if (p->args[i]) {
			if (is_string_ptr (p->args[i])) {
				str = get_string (p->args[i]);
				info << str;
			} else {
				info << *p->args[i];
			}
		}
	}

	info << endmsg;
}

void
printaset(PRINTA * p)
{
        Number cycle;

	cycle = dsp->cycle_secs();

	/* adjust interval to be at least one cycle */

	if (*p->ptime < cycle) {
		p->ctime = cycle;
	} else {
		p->ctime = *p->ptime;
	}

	p->lasttime = dsp_real_secs - cycle;

	if (!is_string_ptr (p->name)) {
		p->error ("printa: variable name is not a string");
	}

	p->val_name = get_string (p->name);
}

void
printa (PRINTA *p)

{
        int i = 0;
	int nsmps = ksmps;
	Number *val;

	if (dsp_real_secs - p->lasttime < p->ctime) {
		return;
	}
	
	info << p->MODULE->name() << ": " << p->val_name << ": " << endl;

	val = p->val;

	do {
		info << "[" << nsmps << "] = " << *val++ << endl;

	} while (--nsmps);
	
	info << endmsg;

	p->lasttime = dsp_real_secs;
}

void
printkset(PRINTK * p)
{
        Number cycle;

	cycle = dsp->cycle_secs();

	if (*p->ptime < cycle)
		p->ctime = cycle;
	else
		p->ctime = *p->ptime;

	p->lasttime = dsp_real_secs - cycle;
	p->space = (size_t) *p->pspace;
}

void
printk(PRINTK * p)
{
	size_t i;

	if (dsp_real_secs - p->lasttime < p->ctime) {
		return;
	}

	info << p->MODULE->name() << ": ";

	/* add spaces, as requested */

	for (i = 0; i < p->space; i++) {
		info << ' ';
	}

	info << *p->val << endmsg;

	p->lasttime = dsp_real_secs;
}

void
printksset (PRINTKS * p)

{
	Number cycle;

	cycle = dsp->cycle_secs();

	if (*p->ptime < cycle) {
		p->ctime = cycle;
	} else {
		p->ctime = *p->ptime;
	}

	p->lasttime = dsp_real_secs - cycle;

	if (!is_string_ptr (p->fmt)) {
		p->error ("printks: format argument is not a string");
	}

	p->format = get_string (p->fmt);
}

void
printks (PRINTKS * p)
{
	int i;
	qm_fixed_string buf;
	Number local_args[TEXTMSG_MAXARGS];

	if (dsp_real_secs - p->lasttime < p->ctime) {
		return;
	}

	/* grab any string arguments and convert them */

	for (i = 0; i < TEXTMSG_MAXARGS; i++) {
		if (!p->args[i]) {
			local_args[i] = 0;
		} else if (is_string_ptr (p->args[i])) {
			
			/* XXX gack, gack, gack.

			   This is a disgusting hack. I can't think
			   of another way to pass both char * and Number
			   to sprintf. 

			   It relies on the idea that sizeof(char *) ==
			   sizeof (Number)
			*/

			local_args[i] = *((Number *) get_string (p->args[i]));
		} else {
			local_args[i] = *p->args[i];
		}
	}

	/* XXX how to make this depend on TEXTMSG_MAXARGS ? */

	sprintf (buf, p->format, 
		 local_args[0],
		 local_args[1],
		 local_args[2],
		 local_args[3],
		 local_args[4],
		 local_args[5],
		 local_args[6],
		 local_args[7],
		 local_args[8],
		 local_args[9]);

	info << p->MODULE->name() << ": " << buf << endmsg;

	p->lasttime = dsp_real_secs;
}

void
printkdset(PRINTKD * p)
{
	if (!is_string_ptr (p->pname)) {
		p->error ("printkd: first argument is not a string");
	}

	p->name = get_string (p->pname);
	p->oldvalue = (Number) 0xfeedface; /* some random value */
}

void
printkd(PRINTKD * p)
{
	Number value = *p->val;

	if (p->oldvalue != value) {
		info << p->MODULE->name() << ": " 
		     << p->name << " = " << value << endmsg;

		p->oldvalue = value;
	}
}

Opcode opcodes[] = 
{
	PRINTK_OPCODE_LIST,
	{ NULL }
};
