/*
    Copyright (C) 1998-99 Paul Barton-Davis 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: multisample.h,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#ifndef __qm_multisample_h__
#define __qm_multisample_h__

#include <qhash_map.h>

#include <quasimodo/opcode_defs.h>
#include <quasimodo/types.h>
#include <quasimodo/function_tables.h>

class MultiSample;

typedef qhash_map<const char *, MultiSample *> MultiSamples;

class MultiSample {

  public:
    void ref() { refcnt++; }
    void unref() { refcnt--; }
    void inuse () { return refcnt; }
    void lock ();
    void unlock ();

    static void erase (MultiSample *ms);
    static MultiSample *make (Number low, Number high, 
			      const char *soundfile);
  private:
    Number low;
    Number high;
    const char *sample_name;
    RCPointer<FunctionTable> table;
    MultiSamples::iterator ms_position;
    pthread_mutex_t _lock;

    MultiSample ();
    ~MultiSample ();

    static MultiSamples multiSamples;
};

OpcodeArgument(MULTISAMPLE)
    Number *table;
    Number *base_frequency;

    Number *msname;
    Number *frequency;
};

#define MULTISAMPLE_OPCODE_LIST \
{"multisample", S(MULTISAMPLE), EventTime, "XX", "X", \
	 NULL, F(multisample_pick) }

#endif  __qm_multisample_h__
