/*
    Permission granted for GPL release by Gabriel Maldonado, April 1999

    Copyright (C) 1998-99 Gabriel Maldonado

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: midiout.h,v 1.3 1999/11/29 18:44:32 pbd Exp $
*/

#ifndef __midiout_h__
#define __midiout_h__

#include <quasimodo/opcode_defs.h>
#include <midi++/types.h>

OpcodeArgument(MCLOCK)
	Number	*freq;
	Number  period, clock_tics;
	bool 	beginning_flag;
};

OpcodeArgument(MRT)
	Number	*message;
};

OpcodeArgument(OUT_ON)
	Number  *ichn,*inum,*ivel;
};


OpcodeArgument(OUT_ON_DUR)
	Number    *ichn,*inum,*ivel,*idur;
	Number     istart_time;
	MIDI::byte chn, num, vel;
	bool       fl_expired, fl_extra_dur;
};


OpcodeArgument(MOSCIL)
	Number    *kchn,*knum,*kvel,*kdur,*kpause;
	Number     istart_time;
	MIDI::byte last_chn, last_num, last_vel;
	Number     last_dur, last_pause;
	bool       fl_note_expired, fl_first_note, fl_end_note;
};

OpcodeArgument(KOUT_ON)
	Number    *kchn,*knum,*kvel;
	MIDI::byte last_chn, last_num, last_vel;
	bool       fl_note_expired, fl_first_note;
};

OpcodeArgument(OUT_CONTR)
	Number  *chn,*num, *value, *min, *max;
	MIDI::byte last_value;
};

OpcodeArgument(OUT_CONTR14)
	Number  *chn, *msb_num, *lsb_num, *value, *min, *max;
	MIDI::byte last_value;
};

OpcodeArgument(OUT_PB)
	Number  *chn, *value, *min, *max;
	int32    last_value;
};

OpcodeArgument(OUT_ATOUCH)
	Number     *chn, *value, *min, *max;
	MIDI::byte  last_value;
};

OpcodeArgument(OUT_PCHG)
	Number    *chn, *prog_num, *min, *max;
	MIDI::byte last_prog_num;
};

OpcodeArgument(OUT_POLYATOUCH)
	Number    *chn, *num, *value, *min, *max;
	MIDI::byte last_value;
};

OpcodeArgument(MIDION2)
	Number     *kchn,*knum,*kvel,*ktrig;
	MIDI::byte last_chn, last_num, last_vel;
	bool       fl_note_expired;
};

OpcodeArgument(MIDIOUT)
	Number  *in_type, *in_chan, *in_dat1, *in_dat2;
};

OpcodeArgument(NRPN)
	Number  *chan, *parm_num, *parm_value;
	MIDI::byte old_chan, old_parm, old_value;
};

OpcodeArgument(DELTAB)
	unsigned char dat1;
	unsigned char dat2;
	Number	delay;
};

#define DELTAB_LENGTH 1000

OpcodeArgument(MDELAY)
	Number      *in_status, *in_chan, *in_dat1, *in_dat2, *kdelay;
	MIDI::byte   status[DELTAB_LENGTH];
	MIDI::byte   chan[DELTAB_LENGTH];
	MIDI::byte   dat1[DELTAB_LENGTH];
	MIDI::byte   dat2[DELTAB_LENGTH];
	Number       time[DELTAB_LENGTH];
	uint32       write_index, read_index;
};

extern void mclock_set (MCLOCK *p);
extern void mclock (MCLOCK *p);
extern void mrtmsg (MRT *p);
extern void iout_on (OUT_ON *p);
extern void iout_off (OUT_ON *p);
extern void iout_on_dur_set (OUT_ON_DUR *p);
extern void iout_on_dur (OUT_ON_DUR *p);
extern void iout_on_dur2 (OUT_ON_DUR *p);
extern void moscil_set (MOSCIL *p);
extern void moscil (MOSCIL *p);
extern void kvar_out_on_set (KOUT_ON *p);
extern void kvar_out_on (KOUT_ON *p);
extern void out_controller (OUT_CONTR *p);
extern void out_aftertouch (OUT_ATOUCH *p);
extern void out_poly_aftertouch (OUT_POLYATOUCH *p);
extern void out_progchange (OUT_PCHG *p);
extern void out_controller14 (OUT_CONTR14 *p);
extern void out_pitch_bend (OUT_PB *p);
extern void midion2_set (MIDION2 *p);
extern void midion2 (MIDION2 *p);
extern void midiout (MIDIOUT *p);
extern void nrpn (NRPN *p);
extern void mdelay_set (MDELAY *p);
extern void mdelay (MDELAY *p);

#define MIDIOUT_OPCODE_LIST \
{"noteon", S(OUT_ON), InitTime, "", "iii", \
	 F(iout_on), NULL, NULL}, \
{"noteoff", S(OUT_ON), InitTime, "", "iii", \
	 F(iout_off), NULL, NULL}, \
{"noteondur", S(OUT_ON_DUR), InitTime|EventTime, "", "iiii", \
	 F(iout_on_dur_set), F(iout_on_dur), NULL}, \
{"noteondur2", S(OUT_ON_DUR), InitTime|EventTime, "", "iiii", \
	 F(iout_on_dur_set), F(iout_on_dur2), NULL}, \
{"moscil", S(MOSCIL), InitTime|EventTime, "", "kkkkk", \
	 F(moscil_set), F(moscil), NULL}, \
{"midiout", S(KOUT_ON), InitTime|EventTime, "", "kkk", \
	 F(kvar_out_on_set), F(kvar_out_on), NULL}, \
{"outic", S(OUT_CONTR), InitTime, "", "iiiii", \
	 F(out_controller), NULL, NULL}, \
{"outkc", S(OUT_CONTR), EventTime, "", "kkkkk", \
	 NULL, F(out_controller), NULL}, \
{"outic14", S(OUT_CONTR14), InitTime, "", "iiiiii", \
	 F(out_controller14), NULL, NULL}, \
{"outkc14", S(OUT_CONTR14), EventTime, "", "kkkkkk", \
	 NULL, F(out_controller14), NULL}, \
{"outipb", S(OUT_PB), InitTime, "", "iiii", \
	 F(out_pitch_bend), NULL, NULL}, \
{"outkpb", S(OUT_PB), EventTime, "", "kkkk", \
	 NULL, F(out_pitch_bend), NULL}, \
{"outiat", S(OUT_ATOUCH), InitTime, "", "iiii", \
	 F(out_aftertouch), NULL, NULL}, \
{"outkat", S(OUT_ATOUCH), EventTime, "", "kkkk", \
	 NULL, F(out_aftertouch), NULL}, \
{"outipc", S(OUT_PCHG), InitTime, "", "iiii", \
	 F(out_progchange), NULL, NULL}, \
{"outkpc", S(OUT_PCHG), EventTime, "", "kkkk", \
	 NULL, F(out_progchange), NULL}, \
{"outipat", S(OUT_POLYATOUCH), InitTime, "", "iiiii", \
	 F(out_poly_aftertouch), NULL, NULL}, \
{"outkpat", S(OUT_POLYATOUCH), EventTime, "", "kkkkk", \
	 NULL, F(out_poly_aftertouch), NULL}, \
{"mclock", S(MCLOCK), InitTime|EventTime, "", "i", \
	 F(mclock_set), F(mclock), NULL}, \
{"mrtmsg", S(MRT), InitTime, "", "i", \
	 F(mrtmsg), NULL, NULL}, \
{"midiout", S(MIDIOUT), EventTime, "", "kkkk", \
	 NULL, F(midiout), NULL}, \
{"midion2", S(MIDION2), InitTime|EventTime, "", "kkkk", \
	 F(midion2_set), F(midion2), NULL}, \
{"nrpn", S(NRPN), EventTime, "", "kkk", NULL, F(nrpn), NULL}
	
	
#endif __midiout_h__

