/*
    Permission granted for GPL release by Gabriel Maldonado, April 1999

    Copyright (C) 1998-99 Gabriel Maldonado

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: midiout.cc,v 1.3 1999/12/17 14:51:54 pbd Exp $
*/


/****************************************/
/** midiout UGs by Gabriel Maldonado   **/
/****************************************/

/* Some modifications by JPff for general use */
/* Modifications for Quasimodo by Paul Barton-Davis */
/* release and extra_time moved to timeops.{cc,h} */

#include <math.h>
#include <string.h>
#include <stdlib.h>

#include <midi++/port.h>
#include <midi++/channel.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_enums.h>
#include <quasimodo/process.h>
#include <quasimodo/dspstat.h>

#include "timeops.h"
#include "midiout.h"

#define NUMCHN          (16)
#define PORT p->PROCESS->midi_port()
#define CHANNEL(n) PORT->channel((n))

void
mclock_set(MCLOCK * p)
{
	p->period = 1.0 / *p->freq;
	p->clock_tics = dsp_real_secs;
	p->beginning_flag = true;
}

void
mclock(MCLOCK * p)
{
	if (p->beginning_flag) {	/* first time */
		PORT->three_byte_msg(0xF8, 0, 0);	/* clock message */
		p->beginning_flag = false;
		return;
	} else if (dsp_real_secs > p->clock_tics) {
		PORT->three_byte_msg(0xF8, 0, 0);	/* clock message */
		p->clock_tics += p->period;
	}
}

void
mrtmsg(MRT * p)
{
	switch ((int) *p->message) {
	case 0:
		PORT->three_byte_msg(0xFC, 0, 0);	/* stop */
		break;
	case 1:
		PORT->three_byte_msg(0xFA, 0, 0);	/* start */
		break;
	case 2:
		PORT->three_byte_msg(0xFB, 0, 0);	/* continue */
		break;
	case -1:
		PORT->three_byte_msg(0xFF, 0, 0);	/* system_reset */
		break;
	case -2:

		PORT->three_byte_msg(0xFE, 0, 0);	/* active_sensing */
		break;
	default:
	        p->error ("illegal mrtmsg argument (%d)",
			       (int) *p->message);
	}
}

void
iout_on(OUT_ON * p)
{
	CHANNEL ((int) *p->ichn - 1)->note_on ((int) *p->inum, (int) *p->ivel);
}

void
iout_off(OUT_ON * p)
{
	CHANNEL ((int) *p->ichn - 1)->note_off((int) *p->inum, (int) *p->ivel);
}

void
iout_on_dur_set(OUT_ON_DUR * p)
{
	int16 temp;

	if (p->PROCESS->extra_time < DEFAULT_XTRADUR) {
		/* if not initialized by another opcode */
		p->PROCESS->extra_time = DEFAULT_XTRADUR;
	}

	p->chn = (temp = abs((int) *p->ichn - 1)) < NUMCHN ? temp : NUMCHN - 1;
	p->num = (temp = abs((int) *p->inum)) < 128 ? temp : 127;
	p->vel = (temp = abs((int) *p->ivel)) < 128 ? temp : 127;

	CHANNEL (p->chn)->note_on (p->num, p->vel);
	p->istart_time = dsp_real_secs;
	p->fl_expired = false;
	p->fl_extra_dur = false;
}

void
iout_on_dur(OUT_ON_DUR * p)
{
	if (!(p->fl_expired)) {
		Number actual_dur = dsp_real_secs - p->istart_time;
		Number dur = *p->idur;
		if (dur < actual_dur) {
			p->fl_expired = true;
			CHANNEL (p->chn)->note_off(p->num, p->vel);
		} else if (p->PROCESS->releasing()) {
			p->fl_expired = true;
			CHANNEL (p->chn)->note_off(p->num, p->vel);
		}
	}
}

void
iout_on_dur2(OUT_ON_DUR * p)
{
	if (!(p->fl_expired)) {
		Number actual_dur = dsp_real_secs - p->istart_time;
		Number dur = *p->idur;
		if (dur < actual_dur) {
			p->fl_expired = true;
			CHANNEL (p->chn)->note_off (p->num, p->vel);

		} else if (p->PROCESS->releasing() || p->fl_extra_dur) {

			if (!p->fl_extra_dur && dur > actual_dur) {
				p->PROCESS->extend_by
					(dur - actual_dur + 1.0f);
				p->PROCESS->unset_releasing();
				p->fl_extra_dur = true;
			} else if (dur <= actual_dur) {
				CHANNEL (p->chn)->note_off (p->num, p->vel);
			}
		}
	}
}

void
moscil_set(MOSCIL * p)
{
	if (p->PROCESS->extra_time < DEFAULT_XTRADUR) {
		/* if not initialized by another opcode */
		p->PROCESS->extra_time = DEFAULT_XTRADUR;
	}
	p->istart_time = dsp_real_secs;
	p->fl_first_note = true;
	p->fl_note_expired = true;
	p->fl_end_note = false;
}

void
moscil(MOSCIL * p)
{
	if (p->fl_first_note) {
		p->fl_first_note = false;
		goto first_note;
	}

	if (!(p->fl_note_expired)) {
		if (p->PROCESS->releasing()) {
			p->fl_note_expired = true;
			p->fl_end_note = true;
			CHANNEL (p->last_chn)->note_off (p->last_num, p->last_vel);
		} else if (p->last_dur < dsp_real_secs - p->istart_time) {
			p->fl_note_expired = true;
			CHANNEL (p->last_chn)->note_off (p->last_num, p->last_vel);
		}

	} else {

		if (!p->fl_end_note
		    && (p->last_dur + p->last_pause) <
		    (dsp_real_secs - p->istart_time)
		    && !(p->PROCESS->releasing())) {

			p->istart_time = dsp_real_secs;
			p->last_dur = *p->kdur;
			p->last_pause = *p->kpause;

		      first_note:
			{
				int16 temp;
				p->last_chn = (temp = abs((int) *p->kchn - 1))
				    < NUMCHN ? temp : NUMCHN - 1;
				p->last_num = (temp = abs((int) *p->knum)) <
				    128 ? temp : 127;
				p->last_vel = (temp = abs((int) *p->kvel)) <
				    128 ? temp : 127;
			}
			p->fl_note_expired = false;
			CHANNEL (p->last_chn)->note_on (p->last_num, p->last_vel);
		}
	}
}


void
kvar_out_on_set(KOUT_ON * p)
{
	if (p->PROCESS->extra_time < DEFAULT_XTRADUR) {
		/* if not initialized by another opcode */
		p->PROCESS->extra_time = DEFAULT_XTRADUR;
	}
	p->fl_first_note = true;
}


void
kvar_out_on(KOUT_ON * p)
{
	if (p->fl_first_note) {
		int16 temp;

		p->last_chn = (temp = abs((int) *p->kchn - 1)) < NUMCHN ? temp
		    : NUMCHN - 1;
		p->last_num = (temp = abs((int) *p->knum)) < 128 ? temp : 127;
		p->last_vel = (temp = abs((int) *p->kvel)) < 128 ? temp : 127;
		p->fl_first_note = false;
		p->fl_note_expired = false;

		CHANNEL (p->last_chn)->note_on (p->last_num, p->last_vel);
	} else if (p->fl_note_expired) {
		return;
	} else {
		if (p->PROCESS->releasing()) {
			CHANNEL (p->last_chn)->note_off (p->last_num, p->last_vel);
			p->fl_note_expired = true;
		} else {
			int16 temp;
			int16 curr_chn = (temp = abs((int) *p->kchn - 1)) <
			NUMCHN ? temp : NUMCHN - 1;
			int16 curr_num = (temp = abs((int) *p->knum)) < 128 ?
			temp : 127;
			int16 curr_vel = (temp = abs((int) *p->kvel)) < 128 ?
			temp : 127;

			if (p->last_chn != curr_chn
			    || p->last_num != curr_num
			    || p->last_vel != curr_vel
			    ) {
				CHANNEL (p->last_chn)->note_off (p->last_num,
					 p->last_vel);

				p->last_chn = curr_chn;
				p->last_num = curr_num;
				p->last_vel = curr_vel;

				CHANNEL (curr_chn)->note_on (curr_num, curr_vel);
			}
		}
	}
}


void
out_controller(OUT_CONTR * p)
{
	int16 value;
	Number min = *p->min;
	value = (int) ((*p->value - min) * 127. / (*p->max - min));
	value = (value < 128) ? value : 127;
	value = (value > -1) ? value : 0;
	if (value != p->last_value) {
		CHANNEL((int) *p->chn - 1)->control ((int) *p->num, value);
		p->last_value = value;
	}
}

void
out_aftertouch(OUT_ATOUCH * p)
{
	int16 value;
	Number min = *p->min;
	value = (int) ((*p->value - min) * 127. / (*p->max - min));
	value = value < 128 ? value : 127;
	value = value > -1 ? value : 0;
	if (value != p->last_value) {
		CHANNEL ((int) *p->chn - 1)->aftertouch (value);
		p->last_value = value;
	}
}

void
out_poly_aftertouch(OUT_POLYATOUCH * p)
{
	int16 value;
	Number min = *p->min;

	value = (int) ((*p->value - min) * 127. / (*p->max - min));
	value = value < 128 ? value : 127;
	value = value > -1 ? value : 0;
	if (value != p->last_value) {
		CHANNEL((int) *p->chn - 1)->poly_aftertouch 
			((int) *p->num, value);
		p->last_value = value;
	}
}

void
out_progchange(OUT_PCHG * p)
{
	int16 prog_num;
	Number min = *p->min;
	prog_num = (int) ((*p->prog_num - min) * 127. / (*p->max -
							 min));
	prog_num = prog_num < 128 ? prog_num : 127;
	prog_num = prog_num > -1 ? prog_num : 0;
	if (prog_num != p->last_prog_num) {
                CHANNEL ((int) *p->chn - 1)->program_change (prog_num);
		p->last_prog_num = prog_num;
	}
}



void
out_controller14(OUT_CONTR14 * p)
{
	int16 value;
	Number min = *p->min;
	
	value = (int) ((*p->value - min) * 16383. / (*p->max - min));
	value = (value < 16384) ? value : 16383;
	value = (value > -1) ? value : 0;
	
	if (value != p->last_value) {
		uint16 msb = value >> 7;
		uint16 lsb = value & 0x7F;

		info << "out contr14 msb:" << msb 
		     << " lsb:" << lsb 
		     << endmsg;

		
		CHANNEL((int) *p->chn - 1)->control ((int) *p->msb_num, msb);
		CHANNEL((int) *p->chn - 1)->control ((int) *p->lsb_num, lsb);
		p->last_value = value;
	}
}

void
out_pitch_bend(OUT_PB * p)
{
	int16 value;
	Number min = *p->min;
	
	value = (int) ((*p->value - min) * 16383. / (*p->max - min));
	value = value < 16384 ? value : 16383;
	value = value > -1 ? value : 0;
	if (value != p->last_value) {
		uint16 msb = value >> 7;
		uint16 lsb = value & 0x7F;
		CHANNEL((int) *p->chn - 1)->pitchbend (msb, lsb);
		p->last_value = value;
	}
}

void
midion2_set(MIDION2 * p)
{
	if (p->PROCESS->extra_time < DEFAULT_XTRADUR) {
		/* if not initialized by another opcode */
		p->PROCESS->extra_time = DEFAULT_XTRADUR;
	}
	/*p->fl_first_note = true; */
	p->fl_note_expired = false;
}

void
midion2(MIDION2 * p)
{
	/*
	   if (p->fl_first_note) {  
	   register int16 temp;           

	   p->last_chn = (temp = abs((int) *p->kchn)) < NUMCHN  ? temp :
	   NUMCHN-1;
	   p->last_num = (temp = abs((int) *p->knum)) < 128     ? temp : 127; 
	   p->last_vel = (temp = abs((int) *p->kvel)) < 128     ? temp : 127;
	   p->fl_first_note   = false;
	   p->fl_note_expired = false;

	   CHANNEL (p->last_chn)->note_on (p->last_num, p->last_vel);
	   }

	 */
	/*else */
	if (p->fl_note_expired)
		return;
	else {
		if (p->PROCESS->releasing()) {
			CHANNEL (p->last_chn)->note_off (p->last_num, p->last_vel);
			p->fl_note_expired = true;
		} else {
			register int16 temp;

			register int16 curr_chn = (temp = abs((int) *p->kchn -
					   1)) <= NUMCHN ? temp : NUMCHN;
			register int16 curr_num = (temp = abs((int) *p->knum)) <
			128 ? temp : 127;
			register int16 curr_vel = (temp = abs((int) *p->kvel)) <
			128 ? temp : 127;

			if ((int) (*p->ktrig + .5) != 0) {	/* i.e. equal 
								   to 1  */
				/*   p->last_chn != curr_chn
				   || p->last_num != curr_num 
				   || p->last_vel != curr_vel
				   ) */
				CHANNEL (p->last_chn)->note_off (p->last_num,
								 p->last_vel);
				p->last_chn = curr_chn;
				p->last_num = curr_num;
				p->last_vel = curr_vel;
				CHANNEL (curr_chn)->note_on (curr_num, curr_vel);
			}
		}
	}
}


void
midiout(MIDIOUT * p)
{				/*gab-A6 fixed */
	int16 kstatus;
	if ((kstatus = (int) *p->in_type)) {
		PORT->three_byte_msg
			((int) *p->in_type | (int) *p->in_chan - 1,
			 (int) *p->in_dat1, (int) *p->in_dat2);
	}
}

void
nrpn(NRPN * p)
{
	int16 chan = (int) *p->chan - 1;
	int16 parm = (int) *p->parm_num;
	int16 value = (int) *p->parm_value;

	if (chan != p->old_chan || parm != p->old_parm || value !=
	    p->old_value) {
		register int16 status = 176 | chan;
		register int16 parm_msb = parm >> 7;
		register int16 parm_lsb = parm & 0x7f;

		register int16 value_msb = (value + 8192) >> 7;
		register int16 value_lsb = (value + 8192) % 128;

		PORT->three_byte_msg(status, 99, parm_msb);
		PORT->three_byte_msg(status, 98, parm_lsb);
		PORT->three_byte_msg(status, 6, value_msb);
		PORT->three_byte_msg(status, 38, value_lsb);
		p->old_chan = chan;
		p->old_parm = parm;
		p->old_value = value;
	}
}


void
mdelay_set(MDELAY * p)
{
	p->read_index = 0;
	p->write_index = 0;
	memset (p->status, 0, DELTAB_LENGTH);
}

void
mdelay(MDELAY * p)
{				/*gab-A6 fixed */

	int16 read_index = p->read_index % DELTAB_LENGTH;
	int16 write_index = p->write_index % DELTAB_LENGTH;

	if (((int) *p->in_status == 0x90 || (int) *p->in_status == 0x80)) {
		p->status[write_index] = (int) *p->in_status;
		p->chan[write_index] = (int) *p->in_chan - 1;
		p->dat1[write_index] = (int) *p->in_dat1;
		p->dat2[write_index] = (int) *p->in_dat2;
		p->time[write_index] = dsp_real_secs;
		p->write_index++;
	}
	if (p->status[read_index] && p->time[read_index] + *p->kdelay <=
	    dsp_real_secs) {
		int16 number = p->dat1[read_index];
		int16 velocity = p->dat2[read_index];
		PORT->three_byte_msg
		    (p->status[read_index] | p->chan[read_index],
		     ((number > 127) ? 127 : number),
		     ((velocity > 127) ? 127 : velocity));
		p->read_index++;
	}
}


Opcode opcodes[] =
{
	MIDIOUT_OPCODE_LIST,
	{NULL}
};
