#ifndef __physmod_marimba_h__
#define __physmod_marimba_h__

/*******************************************/
/*  Marimba SubClass of Modal4 Module, */
/*  by Perry R. Cook, 1995-96              */ 
/*                                         */
/*   Controls:               stickHardness */
/*                           strikePosition*/
/*		             vibFreq       */
/*		             vibAmt        */
/*******************************************/

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

OpcodeArgument(MARIMBA)
    Number	*ar;                  /* Output */
    Number	*amplitude, *frequency;
    Number	*hardness, *spos, *ifn;
    Number	*vibFreq, *vibAmt, *ivfn, *dettack;
    Modal4	m4;
    int32	multiStrike;  
    Number	strikePosition;
    Number 	stickHardness;
    int32	kloop;
};

extern void marimbaset(MARIMBA*);
extern void marimba(MARIMBA*);

#define MARIMBA_OPCODE_LIST \
{"marimba", S(MARIMBA), InitTime|AudioTime, "a", "kkiiikkii", \
	 F(marimbaset), NULL, F(marimba), 0, "physutil" }

#endif __physmod_marimba_h__

