/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: internal_opcodes.cc,v 1.2 1999/11/02 23:50:01 pbd Exp $
*/

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/module.h>
#include <quasimodo/process.h>

#include "internal_opcodes.h"

void
patched (PATCHPTR *p)

{
	*p->result = p->MODULE->is_patched (p->ptr);
}
	
void
voicelimit (VOICELIMIT *p)

{
	p->MODULE->set_process_limit ((long) *p->n);
}

void
polyphonic (BASIC_OP_ARG *p)

{
	p->MODULE->set_process_limit (-1L);
}

void
midibind (BASIC_OP_ARG *p)

{
	/* relax, its all in the flags */
}

Opcode opcodes[] = 

{
	INTERNAL_OPCODE_LIST,
	{ NULL }
};

