/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: gaver.h,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/



#ifndef __qm_gaver_h__
#define __qm_gaver_h__

#include <quasimodo/opcode_defs.h>

#if 1
template<typename X>
class rt_sin {
	X _sin, _cos;
	X _d;
	
public:

	rt_sin(X freq=440)
	: _sin(0), _cos(1)
	{
		set_frequency(freq);
	}
	
	void reset() {
		_sin=0;
		_cos=1;
	}
	
	X sin() const {
		return _sin;
	}
	X cos() const {
		return _cos;
	}
	void next_sample() {
		_sin = _sin + _cos * _d;
		_cos = _cos - _sin * _d;
	}
	void set_frequency(X freq) {
		const X reald = 1/10.0;
		_d = ((2 * M_PI) + reald) * freq / esr;
	}
};
	
#endif

static const int MAXFILTERS = 20;

OpcodeArgument(GAVER_FILTER)
        Number 	*out;
        Number	*in, *size, *shape, *material;
		Number	xnm1[MAXFILTERS], xnm2[MAXFILTERS], ynm1[MAXFILTERS], ynm2[MAXFILTERS];
		Number filters[MAXFILTERS][3];
};

OpcodeArgument(GAVER_SCRAPE)
		Number *out;
		Number *speed, *roughness, *amp;
		Number lastin;
		int phase;
};

OpcodeArgument(GAVER_IMPACT)
		Number *out;
		Number *hardness, *amp;
		int phase, impulse_length;
//		rt_sin<Number> thesin;
		Number a,b;
};


extern void gaver_filter_set (GAVER_FILTER *p);
extern void gaver_filter_audio (GAVER_FILTER *p);


extern void gaver_scrape_set (GAVER_SCRAPE *p);
extern void gaver_scrape_audio  (GAVER_SCRAPE *p);


extern void gaver_impact_set (GAVER_IMPACT *p);
extern void gaver_impact_audio  (GAVER_IMPACT *p);


#define GAVER_OPCODE_LIST \
{ \
	"gaverfilter", S(GAVER_FILTER), InitTime|EventTime|AudioTime, "a", "aXXX", \
	  F(gaver_filter_set), NULL, F(gaver_filter_audio) \
}, \
{ \
	"gaverscrape", S(GAVER_SCRAPE), InitTime|EventTime|AudioTime, "a", "XXX", \
	  F(gaver_scrape_set), NULL, F(gaver_scrape_audio) \
}, \
{ \
	"gaverimpact", S(GAVER_IMPACT), InitTime|EventTime|AudioTime, "a", "XX", \
	  F(gaver_impact_set), NULL, F(gaver_impact_audio) \
}

#endif // __qm_gaver_h__
