/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: ftgen.cc,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/

#include <stdio.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_enums.h>
#include <quasimodo/function_tables.h>
#include <quasimodo/generators.h>

#include "ftgen.h"

void
ftgen (FTGEN *p)

{
	FunctionTableRequest req;
	size_t i;

	if (is_string_ptr (p->generator)) {
	    req.gen = generatorManager->find (get_string (p->generator));
	} else {
	    req.gen = generatorManager->find ((Generator::Type) *p->generator);
	}

	if (req.gen == NULL) {
	    p->error ("ftgen: no such generator");
	}

	if (is_string_ptr (p->tablename)) {
		req.function_name = get_string (p->tablename);
	} else {
		/* XXX memory leak */
		req.function_name = new char[8];
		sprintf ((char *)req.function_name, "%d", (int) *p->tablename);
	}

	req.nelements = (int32) *p->tablesize;
	req.start_time = 0;

	/* XXX handling starttime != 0 ... create a DspRequest
	   and submit it to the DSP (ourselves), then leave.
	*/

	/* Copy remaining argument list
	*/

	req.argc = p->INOCOUNT - 4; /* first four in_args are standard
				       function table params, although
				       this implementation currently
				       pays no attention to the
				       startime field.
				    */
	

	/* generators that use an input filename accept it
	   *only* as their fifth argument (which in p->args[0]).
	   Check to see if we have a string there or not.
	*/

	if (req.argc > 0) {
		if (is_string_ptr (p->args[0])) {
			if ((req.gen->flags & Generator::usesFile) == 0) {
				p->error (
					       "ftgen: string arg not "
					       "allowed for "
					       "generator %s", 
					       req.gen->name);
				
			} else {
				req.filename = get_string (p->args[0]);
			}

		} else {
			if ((req.gen->flags & Generator::usesFile)) {
				p->error ("ftgen: string arg "
					     "required for "
					     "generator %s", 
					     req.gen->name);
			}
		}
	}
		
	req.args = new Number[req.argc];

	for (i = 0; i < req.argc; i++) {
		req.args[i] = *p->args[i];
	}

	if (FunctionTable::generate (&req) == 0) {
		p->error ("ftgen: table generation error");
	}
}

Opcode opcodes[] = 

{
	FTGEN_OPCODE_LIST,
	{ NULL }
};
