#ifndef __fm4op_h__
#define __fm4op_h__


/*******************************************/
/*  Master Class for 4 Operator FM Synth   */
/*  by Perry R. Cook, 1995-96              */ 
/*  This module contains an 4 waves,   */
/*  4 envelopes, and various state vars.   */
/*                                         */
/*  The basic Chowning/Stanford FM patent  */
/*  expired April 1995, but there exist    */
/*  follow-on patents, mostly assigned to  */
/*  Yamaha.  If you are of the type who    */
/*  should worry about this (making money) */
/*  worry away.                            */
/*                                         */
/*******************************************/

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

/*******************************************/
/*  Two Pole Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */ 
/*  See books on filters to understand     */
/*  more about how this works.  Nothing    */
/*  out of the ordinary in this version.   */
/*******************************************/

struct TwoPole {
    Number gain;
    Number onputs[2];
    Number lastOutput;
    Number poleCoeffs[2];
};

/* ********************************************************************** */

OpcodeArgument(FM4OP)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*control1, *control2, *modDepth; /* Control1 doubles as vowel */
    Number	*vibFreq;
    Number	*ifn0, *ifn1, *ifn2, *ifn3, *vifn;

    ADSR	adsr[4]; 
    RCPointer<FunctionTable>	waves[4];
    Number	w_rate[4];         /* Parameters for vibrato */
    Number	w_time[4];
    Number	w_phase[4];
    RCPointer<FunctionTable>	vibWave;
    Number	v_rate;         /* Parameters for vibrato */
    Number	v_time;
    TwoZero	twozero;
    Number	baseFreq;
    Number	ratios[4];
    Number	gains[4];
};

OpcodeArgument(FM4OPV)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*control1, *control2, *modDepth; /* Control1 doubles as vowel */
    Number	*vibFreq;
    Number	*ifn0, *ifn1, *ifn2, *ifn3, *vifn;

    ADSR	adsr[4]; 
    RCPointer<FunctionTable>	waves[4];
    Number	w_rate[4];
    Number	w_time[4];
    Number	w_phase[4];
    RCPointer<FunctionTable>	vibWave;
    Number	v_rate;         /* Parameters for vibrato */
    Number	v_time;         /* Parameters for vibrato */
    TwoZero	twozero;
    Number	baseFreq;
    Number	ratios[4];
    Number	gains[4];
    Number	tilt[3];
    Number	mods[3];
    Number	last_control;
};


extern void build_FM (void);
extern void make_FM4Op (FM4OP *p);
extern void FM4Op_loadWaves (FM4OP *p);
extern void FM4Op_setRatio (FM4OP *p, int32 whichOne, Number ratio);
extern void FM4Op_keyOff (FM4OP *p);
extern Number FM4Alg5_tick (FM4OP *p, Number c1, Number c2);
extern void tubebellset (FM4OP *p);
extern void tubebell (FM4OP *p);
extern void rhodeset (FM4OP *p);
extern void wurleyset (FM4OP *p);
extern void wurley (FM4OP *p);
extern Number FM4Alg3_tick (FM4OP *p, Number c1, Number c2);
extern void heavymetset (FM4OP *p);
extern void heavymet (FM4OP *p);
extern Number FM4Alg8_tick (FM4OP *p, Number c1, Number c2);
extern void b3set (FM4OP *p);
extern void hammondB3 (FM4OP *p);
extern Number FM4Alg6_tick (FM4OPV *q);
extern void FMVoices_setFreq (FM4OPV *q, Number frequency);
extern void FMVoiceset (FM4OPV *q);
extern void FMVoice (FM4OPV *q);
extern Number FM4Alg4_tick (FM4OP *p, Number c1, Number c2);
extern void percfluteset (FM4OP *p);
extern void percflute (FM4OP *p);

#define FM4OP_OPCODE_LIST \
{"fmbell", S(FM4OP), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(tubebellset), NULL, F(tubebell), 0, "physutil" }, \
{"fmrhode", S(FM4OP), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(rhodeset), NULL, F(tubebell), 0, "physutil" }, \
{"fmwurlie", S(FM4OP), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(wurleyset), NULL, F(wurley), 0, "physutil" }, \
{"fmmetal", S(FM4OP), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(heavymetset), NULL, F(heavymet), 0, "physutil" }, \
{"fmb3", S(FM4OP), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(b3set), NULL, F(hammondB3), 0, "physutil" }, \
{"fmvoice", S(FM4OPV), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(FMVoiceset), NULL, F(FMVoice), 0, "physutil" }, \
{"fmpercfl", S(FM4OP), InitTime|AudioTime, "a", "kkkkkkiiiii",  \
	 F(percfluteset), NULL, F(percflute), 0, "physutil" }


#endif __fm4op_h__

