/*
    Copyright (C) 1998 Gabriel Maldonado 

    GPL release granted to Paul Barton-Davis via email, April 1999.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    aint32 with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: flanger.cc,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/

/* Flanger by Maldonado, with coding enhancements by JPff -- July 1998
   Ported to Quasimodo, pbd, May 1999
*/

#include <math.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>

#include "flanger.h"

void
flanger_set(FLANGER * p)
{
/*---------------- delay  -----------------------*/
	p->maxdelay = (uint32) (*p->maxd * esr);
	p->aux.alloc (p->maxdelay * sizeof (Number));
	p->left = 0;
	p->yt1 = 0.0f;
	p->fmaxd = (Number) p->maxdelay;
}

void
flanger(FLANGER * p)
{
/*---------------- delay -----------------------*/
	uint32 indx = p->left;
	Number *out = p->ar;	/* assign object data to local variables  
				 */
	Number *in = p->asig;
	Number maxdelay = p->fmaxd, maxdelayM1 = maxdelay - 1;
	Number *buf = (Number *) p->aux.auxp;
	Number *freq_del = p->xdel;
	Number feedback = *p->kfeedback;
	Number fv1;
	int32 v2;
	int32 v1;
	Number *yt1 = &(p->yt1);

	int16 nsmps = ksmps;

	do {
/*---------------- delay -----------------------*/
		buf[indx] = *in++ + (*yt1 * feedback);
		fv1 = indx - (*freq_del++ * esr);	/* Make sure inside
							   the buffer     */
		while (fv1 < 0)
			fv1 += maxdelay;
		v1 = (int32) fv1;
		v2 = (fv1 < maxdelayM1) ? v1 + 1 : 0;	/*Find next sample 
							   for interpolation */
		*out++ = *yt1 = buf[v1] + (fv1 - v1) * (buf[v2] - buf[v1]);
		if (++indx == maxdelay)
			indx = 0;	/* Advance current pointer */
	} while (--nsmps);
	p->left = indx;
}

#define MAXDELAY	.2	/* 5 Hz */

void
wguide1set(WGUIDE1 * p)
{
/*---------------- delay -----------------------*/
	p->maxd = (uint32) (MAXDELAY * esr);
	p->aux.alloc (p->maxd * sizeof (Number));
		 

	p->left = 0;
/*---------------- filter -----------------------*/
	p->c1 = p->prvhp = 0.0f;
	p->c2 = 1.0f;
	p->yt1 = 0.0f;
}

void
wguide1(WGUIDE1 * p)
{
/*---------------- delay -----------------------*/
	uint32 indx;
	Number *out = p->ar;	/* assign object data to local variables  
				 */
	Number *in = p->asig;
	Number *buf = (Number *) p->aux.auxp;
	Number freq_del = (1 / *p->xdel) * esr;
	Number feedback = *p->kfeedback;
	Number fv1, fv2, out_delay, bufv1;
	int32 v1;
/*---------------- filter -----------------------*/
	Number c1, c2, *yt1;
	int16 nsmps = ksmps;

/*---------------- delay -----------------------*/
	indx = p->left;
/*---------------- filter -----------------------*/
	if (*p->filt_khp != p->prvhp) {
		Number b;
		p->prvhp = *p->filt_khp;
		b = 2.0f - (Number) cos((double) (*p->filt_khp * tpidsr));
		p->c2 = b - (Number) sqrt((double) (b * b - 1.0));
		p->c1 = 1.0f - p->c2;
	}
	c1 = p->c1;
	c2 = p->c2;
	yt1 = &(p->yt1);
	do {
/*---------------- delay -----------------------*/
		buf[indx] = *in++ + (*yt1 * feedback);
		fv1 = indx - freq_del;	/* Make sure inside the buffer    
					 */
		while (fv1 < 0)
			fv1 += p->maxd;
		fv2 = (fv1 < p->maxd - 1) ? fv1 + 1 : 0;	/* Find next
								   sample for interpolation       */
		bufv1 = buf[v1 = (int32) fv1];
		out_delay = bufv1 + (fv1 - v1) * (buf[(int32) fv2] - bufv1);
		if (++indx == p->maxd)
			indx = 0;	/* Advance current pointer */
/*---------------- filter -----------------------*/
		*out++ = *yt1 = c1 * out_delay + c2 * *yt1;
	} while (--nsmps);
	p->left = indx;
}


void
wguide2set(WGUIDE2 * p)
{
/*---------------- delay1 -----------------------*/
	p->maxd = (uint32) (MAXDELAY * esr);
	p->aux1.alloc (p->maxd * sizeof (Number));
	p->left1 = 0;
/*---------------- delay2 -----------------------*/
	p->aux2.alloc (p->maxd * sizeof (Number));
	p->left2 = 0;
/*---------------- filter1 -----------------------*/
	p->c1_1 = p->prvhp1 = 0.0f;
	p->c2_1 = 1.0f;
	p->yt1_1 = 0.0f;
/*---------------- filter2 -----------------------*/
	p->c1_2 = p->prvhp2 = 0.0f;
	p->c2_2 = 1.0f;
	p->yt1_2 = 0.0f;

	p->old_out = 0.0f;

}

void
wguide2(WGUIDE2 * p)
{
	Number *out = p->ar;
	Number *in = p->asig;
	int16 nsmps = ksmps;
	Number out1, out2, *old_out = &(p->old_out);

/*---------------- delay1 -----------------------*/
	uint32 indx1;
	Number *buf1 = (Number *) p->aux1.auxp;
	Number freq_del1 = (1.0f / *p->xdel1) * esr;
	Number feedback1 = *p->kfeedback1;
	Number fv1_1, fv2_1, out_delay1;
	int32 v1_1;
/*---------------- filter1 -----------------------*/
	Number c1_1, c2_1, *yt1_1;
/*---------------- delay2 -----------------------*/
	uint32 indx2;
	Number *buf2 = (Number *) p->aux2.auxp;
	Number freq_del2 = (1.0f / *p->xdel2) * esr;
	Number feedback2 = *p->kfeedback2;
	Number fv1_2, fv2_2, out_delay2;
	int32 v1_2;
/*---------------- filter2 -----------------------*/
	Number c1_2, c2_2, *yt1_2;
/*-----------------------------------------------*/

	indx1 = p->left1;
	indx2 = p->left2;
	if (*p->filt_khp1 != p->prvhp1) {
		Number b;
		p->prvhp1 = *p->filt_khp1;
		b = 2.0f - (Number) cos((double) (*p->filt_khp1 * tpidsr));
		p->c2_1 = b - (Number) sqrt((double) (b * b) - 1.0);
		p->c1_1 = 1.0f - p->c2_1;
	}
	if (*p->filt_khp2 != p->prvhp2) {
		Number b;
		p->prvhp2 = *p->filt_khp2;
		b = 2.0f - (Number) cos((double) (*p->filt_khp2 * tpidsr));
		p->c2_2 = b - (Number) sqrt((double) (b * b) - 1.0);
		p->c1_2 = 1.0f - p->c2_2;
	}
	c1_1 = p->c1_1;
	c2_1 = p->c2_1;
	c1_2 = p->c1_2;
	c2_2 = p->c2_2;
	yt1_1 = &(p->yt1_1);
	yt1_2 = &(p->yt1_2);

	do {
		buf1[indx1] = buf2[indx2] =
		    *in++ + (*old_out * feedback1) + (*old_out * feedback2);
		fv1_1 = indx1 - freq_del1;	/*Make sure inside the buffer 
						 */
		fv1_2 = indx2 - freq_del2;	/* Make sure inside the
						   buffer     */
		while (fv1_1 < 0)
			fv1_1 += p->maxd;
		while (fv1_2 < 0)
			fv1_2 += p->maxd;
		fv2_1 = (fv1_1 < p->maxd - 1) ? fv1_1 + 1 : 0;	/*Find
								   next sample for interpolation      */
		fv2_2 = (fv1_2 < p->maxd - 1) ? fv1_2 + 1 : 0;	/*Find
								   next sample for interpolation      */
		v1_1 = (int32) fv1_1;
		v1_2 = (int32) fv1_2;
		out_delay1 = buf1[v1_1] + (fv1_1 - v1_1) * (buf1[(int32) fv2_1]
							    - buf1[v1_1]);
		out_delay2 = buf2[v1_2] + (fv1_2 - v1_2) * (buf2[(int32) fv2_2]
							    - buf2[v1_2]);
		if (++indx1 == p->maxd)
			indx1 = 0;	/* Advance current pointer */
		if (++indx2 == p->maxd)
			indx2 = 0;	/* Advance current pointer */
		out1 = *yt1_1 = c1_1 * out_delay1 + c2_1 * *yt1_1;
		out2 = *yt1_2 = c1_2 * out_delay2 + c2_2 * *yt1_2;
		*out++ = *old_out = out1 + out2;
	} while (--nsmps);
	p->left1 = indx1;
	p->left2 = indx2;
}

Opcode opcodes[] =
{
	FLANGER_OPCODE_LIST,
	{NULL}
};
