/*
    Copyright (C) 1998-99 Paul Barton-Davis 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: channelops.h,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/
#ifndef __qm_channelops_h__
#define __qm_channelops_h__

#include <quasimodo/opcode_defs.h>

OpcodeArgument(MIDIVAL)
    Number  *r, *irange;		/* MWB addition */
    Number  iscal;
};

OpcodeArgument(MIDIBLOCK)
	Number *port;
	Number *channel;
};

OpcodeArgument(MIDIKMAP)
    Number  *r, *ilo, *ihi;
    Number  scale, lo;
};

/* these two duplicate midikset and midibset, but we
   need this for proper module separation, and they
   are small anyway.
*/

extern void chnkset       (MIDIKMAP *);
extern void chnbset       (MIDIVAL *);

extern void chnoteon      (MIDIKMAP *);
extern void chnoteoff     (MIDIKMAP *);
extern void chonveloc     (MIDIKMAP *);
extern void choffveloc    (MIDIKMAP *);
extern void chaftouch     (MIDIKMAP *);
extern void chpchbend     (MIDIKMAP *);
extern void chpchmidi     (MIDIVAL *);
extern void choctmidi     (MIDIVAL *);
extern void chcpsmidi     (MIDIVAL *);
extern void chpchmidib    (MIDIVAL *);
extern void choctmidib    (MIDIVAL *);
extern void chcpsmidib    (MIDIVAL *);
extern void chpchmidib_i  (MIDIVAL *);
extern void choctmidib_i  (MIDIVAL *);
extern void chcpsmidib_i  (MIDIVAL *);

extern void midiblock   (MIDIBLOCK *);
extern void midiresume  (BASIC_OP_ARG *);

#define CHANNELOPS_OPCODE_LIST \
{"midiblock",S(MIDIBLOCK),EventTime,"","", \
	 NULL,F(midiblock),NULL}, \
{"chnoteon",S(MIDIKMAP),EventTime|InitTime,"x","oh", \
	 F(chnkset),F(chnoteon),NULL}, \
{"chnoteoff",S(MIDIKMAP),EventTime|InitTime,"x","oh", \
	 F(chnkset),F(chnoteoff),NULL}, \
{"chonveloc",S(MIDIKMAP),InitTime|EventTime,"x","oh", \
	 F(chnkset),F(chonveloc),NULL}, \
{"choffveloc",S(MIDIKMAP),InitTime|EventTime,"x","oh", \
	 F(chnkset),F(choffveloc),NULL}, \
{"chaftouch",S(MIDIKMAP),InitTime|EventTime,"x","oh", \
	 F(chnkset),F(chaftouch),NULL}, \
{"chpchmidi",S(MIDIVAL),EventTime,"x","", \
	 NULL,F(chpchmidi),NULL}, \
{"choctmidi",S(MIDIVAL),EventTime,"x","", \
	 NULL,F(choctmidi),NULL,}, \
{"chcpsmidi",S(MIDIVAL),EventTime,"x","", \
	 NULL,F(chcpsmidi),NULL,}, \
{"chpchmidib",S(MIDIVAL),EventTime|InitTime,"x","o", \
	 F(chnbset),F(chpchmidib),NULL}, \
{"choctmidib",S(MIDIVAL),InitTime|EventTime,"x","o", \
	 F(chnbset),F(choctmidib),NULL}, \
{"chcpsmidib",S(MIDIVAL),InitTime|EventTime,"x","o", \
	 F(chnbset),F(chcpsmidib),NULL}, \
{"chpchbend",S(MIDIKMAP),EventTime|InitTime,"x","jp", \
	 F(chnkset),F(chpchbend),NULL}

#endif __qm_channelops_h__
