/*
    Copyright (C) 1998-99 Paul Barton-Davis
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: channelops.cc,v 1.4 1999/11/29 18:44:32 pbd Exp $
*/

#include <math.h>

#include <midi++/port.h>
#include <midi++/channel.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_enums.h>
#include <quasimodo/process.h>
#include <quasimodo/module.h>

#include "channelops.h"

static const Number dv127 = (1.0f/127.0f);

void
chnkset(MIDIKMAP * p)
{
	p->lo = *p->ilo;
	p->scale = (*p->ihi - p->lo) * dv127;
}

void
chnbset(MIDIVAL * p)
{
	if (*p->irange > 0) {
		p->iscal = *p->irange;
	} else {
		p->iscal = 2.0f;
	}
}

void
chnoteon (MIDIKMAP * p)
{	
	*p->r = p->lo + p->PROCESS->midi_channel()->last_note_on() * p->scale;
}

void
chnoteoff (MIDIKMAP * p)
{	
	*p->r = p->lo + p->PROCESS->midi_channel()->last_note_off() * p->scale;
}

void
chonveloc(MIDIKMAP * p)
{
	*p->r = p->lo + 
		p->PROCESS->midi_channel()->last_on_velocity() * p->scale;
}

void
choffveloc(MIDIKMAP * p)
{
	*p->r = p->lo + 
		p->PROCESS->midi_channel()->last_off_velocity() * p->scale;
}

void
chpchmidi(MIDIVAL * p)
{
	double fract, oct, ioct;
	oct = p->PROCESS->midi_channel()->last_note_on() / 12.0 + 3.0;
	fract = modf(oct, &ioct);
	fract *= 0.12;
	*p->r = (Number) (ioct + fract);
}

void
chpchmidi_i (MIDIVAL *p)

{
	chnbset (p);
	chpchmidi_i (p);
}

void
chpchmidib(MIDIVAL * p)
{
	MIDI::Channel *mchn = p->PROCESS->midi_channel();

	double fract, oct, ioct;
	oct = (mchn->last_note_on() + (mchn->pitchbend() * p->iscal)) /
		12.0 + 3.0;
	fract = modf(oct, &ioct);
	fract *= 0.12;
	*p->r = (Number) (ioct + fract);
}

void
choctmidi(MIDIVAL * p)
{
	*p->r = p->PROCESS->midi_channel()->last_note_on() / 12.0f + 3.0f;
}

void
choctmidib(MIDIVAL * p)
{
	MIDI::Channel *mchn = p->PROCESS->midi_channel();

	*p->r = (mchn->last_note_on() +
		 (mchn->pitchbend() * p->iscal))/12.0f + 3.0f;
}

void
choctmidib_i (MIDIVAL *p)

{
	chnbset (p);
	choctmidib (p);
}

void
chcpsmidi(MIDIVAL * p)
{
	int32 loct;

	loct = (long) 
	    (((p->PROCESS->midi_channel()->last_note_on()/12.0f) + 3.0f) * octresol);

	*p->r = CPSOCTL(loct);
}

void
chcpsmidib(MIDIVAL * p)
{
	MIDI::Channel *mchn = p->PROCESS->midi_channel();
	Number bend = mchn->pitchbend();
	long loct;

	loct = (long) (((mchn->last_note_on() +
			 bend * p->iscal) / 12.0f + 3.0f) * octresol);
	*p->r = CPSOCTL(loct);
}

void
chcpsmidi_i (MIDIVAL *p)

{
	chnbset (p);
	chcpsmidi (p);
}

void
chaftouch(MIDIKMAP * p)
{
	*p->r = p->lo + p->PROCESS->midi_channel()->pressure() * p->scale;
}

void
chpchbend(MIDIKMAP * p)
{
	*p->r = p->lo + p->PROCESS->midi_channel()->pitchbend() * p->scale;
}

void
midiblock(MIDIBLOCK *p)

{
	p->MODULE->midi_wait (p->PROCESS);
}

Opcode opcodes[] =
{
	CHANNELOPS_OPCODE_LIST,
	{ NULL }
};

