#
# Configure paths for audio facilities
#
# Paul Barton-Davis <pbd@op.net> Fall 1999
#
# Note: for ALSA and OSS, there is always the "raw" /dev/{snd/}/dsp file,
# which can be opened and used without any library support. However, this
# can only be tested for at run time, so we don't try to detect the
# presence of such a device file here.
#

AC_DEFUN(AM_PATH_AUDIO,
[

dnl
dnl currently supports:
dnl         ALSA, OSS, IRIX libaudio, Solaris libaudio
dnl
dnl after execution:
dnl	ac_cv_have_alsa_audio=[yes|no]
dnl	ac_cv_have_oss_audio=[yes|no]
dnl	ac_cv_have_irix_audio=[yes|no]
dnl	ac_cv_have_solaris_audio=[yes|no]
dnl
dnl	use_alsa_audio=[yes|no]
dnl	use_oss_audio=[yes|no]
dnl	use_irix_audio=[yes|no]
dnl	use_solaris_audio=[yes|no]
dnl
dnl     ac_cv_audio_systems=<empty> OR [IRIX [Solaris [ALSA [OSS]]]]
dnl
dnl     AUDIO_LIBS  set to -l... value needed to use audio system
dnl

AC_REQUIRE([AC_CANONICAL_HOST])
	
use_alsa_audio=yes
use_oss_audio=no
use_solaris_audio=yes
use_irix_audio=yes

ac_cv_audio_systems=
ac_cv_have_alsa_audio=no
ac_cv_have_oss_audio=no
ac_cv_have_irix_audio=no
ac_cv_have_solaris_audio=no

AC_ARG_ENABLE(alsa,
	[  --disable-alsa		Disable ALSA Audio],
	[if test x$enableval != xyes ;  then
	    use_alsa_audio=no
	else 
	    use_alsa_audio=yes
	fi
])

AC_ARG_ENABLE(oss,	
	[  --disable-oss		Disable OSS Audio],
	[if test x$enableval != xyes ;  then
	    use_oss_audio=no
	else
	    use_oss_audio=yes
	fi
])

AC_ARG_ENABLE(solaris,
	[  --disable-solaris	Disable Solaris libaudio Audio],
	[if test x$enableval != xyes ;  then
	    use_solaris_audio=no
	else
	    use_solaris_audio=yes
	fi
])

AC_ARG_ENABLE(irix,
	[  --disable-irix		Disable IRIX Audio],
	[if test x$enableval != yes ;  then
	    use_irix_audio=no
	else
	    use_irix_audio=yes
	fi
])

AC_CHECK_LIB(asound,snd_cards,
	     ac_cv_have_alsa_audio=yes,ac_cv_have_alsa_audio=no)
AC_CHECK_HEADER(sys/soundcard.h,
	     ac_cv_have_oss_audio=yes,ac_cv_have_oss_audio=no)
AC_CHECK_LIB(audio,alOpenPort,
	     ac_cv_have_irix_audio=yes,ac_cv_have_irix_audio=no)
AC_CHECK_LIB(audio,audio_set_play_config,
	     ac_cv_have_solaris_audio=yes,ac_cv_have_solaris_audio=no)

if test x$use_alsa_audio = xyes -a x$ac_cv_have_alsa_audio = xyes; then
	ac_cv_audio_systems="$ac_cv_audio_systems ALSA"
	AUDIO_LIBS="$AUDIO_LIBS -lasound"
fi

if test x$use_oss_audio = xyes -a x$ac_cv_have_oss_audio = xyes ; then
	ac_cv_audio_systems="$ac_cv_audio_systems OSS"
fi

if test x$use_irix_audio = xyes -a x$ac_cv_have_irix_audio = xyes ; then
	ac_cv_audio_systems="$ac_cv_audio_systems IRIX"
	AUDIO_LIBS="$AUDIO_LIBS -laudio"
fi

if test x$use_solaris_audio = xyes -a x$ac_cv_have_solaris = xyes ; then
	ac_cv_audio_systems="$ac_cv_audio_systems Solaris"
	AUDIO_LIBS="$AUDIO_LIBS -laudio"
fi

])



