#ifndef INCLUDED_QESESSION_H
#define INCLUDED_QESESSION_H

#include <string>
#include <memory>
#include <vector>

#include <qwidget.h>

#include <kvutils/definition_by_contract.h>
#include <kvutils/temporary_file_directory.h>
#include <ecasound/eca-audio-format.h>

class ECA_CONTROL;
class ECA_SESSION;
class AUDIO_IO;

class QEFileView;
class QEButtonRow;
class QEStatusBar;
class QENonblockingEvent;

class QMainWindow;
class QMenuBar;
class QVBoxLayout;
class QLabel;

#include "resources.h"

/**
 * Ecawave session widget
 *
 * Top level user-interface object. This class holds the application-wide 
 * state information, and controls execution. It also provides global functions 
 * like opening a new file and opening a new session window.
 */
class QESession : public QWidget, public DEFINITION_BY_CONTRACT {
  Q_OBJECT

public slots:

  void timerEvent(QTimerEvent* e);

  void open_file(const string& filename);
  void new_session(void);
  void close_session(void);
  void new_event(void);
  void open_event(void);
  void save_event(void);
  void save_as_event(void);
  void play_event(void);
  void stop_event(void);
  void effect_event(void);
  void copy_event(void);
  void paste_event(void);
  void cut_event(void);
  void fade_in_event(void);
  void fade_out_event(void);
  void debug_event(void);

private slots:

  void position_update(void);
  void update_wave_view(void);

  void set_active_filename(const string& name);
  void set_orig_filename(const string& name);

signals:

  void filename_changed(const string& filename);
  void engine_status(const string& str);

  void new_session_request(void);
  void session_closed(void);

  void state_change_modified(void);
  void state_change_named(void);
  void state_change_no_file(void);

 public:

  /**
   * Whether to use wave form cache
   */
  void toggle_wave_cache(bool v) { wcache_toggle_rep = v; }

  /**
   * Whether to force wave form cache refresh
   */
  void toggle_cache_refresh(bool v) { refresh_toggle_rep = v; }

  QESession (QMainWindow *parent = 0,
	     const char *name = 0);
  ~QESession(void);

 private:

  void init_layout(void);
  void init_menubar(void);
  void prepare_event(void);
  bool active_file_valid(void); 

  void init_temp_directory(void);
  void create_temps(void);
  void remove_temps(void);
  bool temp_files_created(void) const;
  string get_clipboard_location(void);

  void copy_file(const string& a, const string& b);

  void change_state_to_modified(void);
  void change_state_to_named(void);
  void change_state_to_no_file(void);

  enum { 
    state_no_file, // no file loaded/active
    state_named, // file loaded/saved, not modified
    state_modified // file modified
  } state_rep;

  string orig_filename_rep;
  string active_filename_rep;
  vector<string> temp_filenames_rep;
  
  bool temp_files_created_rep;
  TEMPORARY_FILE_DIRECTORY tempfile_dir_rep;

  long int start_pos_rep;
  long int sel_length_rep;

  QEResources ecawaverc_rep;
  
  QEFileView* fileview_repp;
  AUDIO_IO* audio_io_repp;

  QEButtonRow* buttonrow_repp;
  QEButtonRow* buttonrow2_repp;
  QEButtonRow* buttonrow3_repp;
  QLabel* no_file_label_repp;
  QENonblockingEvent* nb_event_repp;

  QMainWindow* mainwindow_repp;
  QMenuBar* menubar_repp;
  QEStatusBar* statusbar_repp;
  QVBoxLayout* vlayout_repp;

  bool refresh_toggle_rep;
  bool wcache_toggle_rep;
  bool direct_mode_rep;

  auto_ptr<ECA_CONTROL> auto_ectrl_rep;
  auto_ptr<ECA_SESSION> auto_esession_rep;

  ECA_CONTROL* ectrl_repp;
  ECA_SESSION* esession_repp;
};

#endif
