# ---
# definitions

%define python_sitepkgsdir %(echo `python -c "import sys; print (sys.prefix + '/lib/python' + sys.version[:3] + '/site-packages/')"`)
%define python_compile_opt python -O -c "import compileall; compileall.compile_dir('.')"
%define python_compile python -c "import compileall; compileall.compile_dir('.')"

# ---
# global settings

Buildroot: /tmp/ecasound-build
Prefix: /usr/local
Packager: Kai Vehmanen <kai.vehmanen@wakkanet.fi>
Distribution: www.eca.cx audio software

# ---
# main package

Name: ecasound
Version: 2.2.0-pre1
Release: 1
Copyright: GPL
Source: http://ecasound.seul.org/download/ecasound-2.2.0-pre1.tar.gz
URL: http://www.eca.cx/ecasound

Summary: ecasound - multitrack audio processing tool
Group: Applications/Sound

%description
Ecasound is a software package designed for multitrack audio
processing. It can be used for simple tasks like audio playback, 
recording and format conversions, as well as for multitrack effect 
processing, mixing, recording and signal recycling. Ecasound supports 
a wide range of audio inputs, outputs and effect algorithms. 
Effects and audio objects can be combined in various ways, and their
parameters can be controlled by operator objects like oscillators 
and MIDI-CCs. A versatile console mode user-interface is included 
in the package.

# ---
# library package - ecasound-devel

%package devel
Summary: Ecasound - development files
Group: Applications/Sound

%description devel
The ecasound-devel package contains the header files and static libraries
necessary for building apps like ecawave and ecamegapedal that
directly link against ecasound libraries.

# ---
# library package - libecasoundc

%package -n libecasoundc
Summary: Ecasound - libecasoundc
Group: Applications/Sound

requires: ecasound

%description -n libecasoundc
Ecasound - libecasoundc package. Provides 
C implementation of the Ecasound Control Interface
(ECI). Both static library files and and header 
files are included in the package.

# ---
# pyecasound

%package -n pyecasound
Summary: Python bindings to ecasound control interface.
Group: Applications/Sound

requires: ecasound

%description -n pyecasound
Python bindings to Ecasound Control Interface (ECI).

# ---
# build phase

%prep
%setup -n ecasound-2.2.0-pre1
%build
./configure --prefix=%{prefix} --disable-static $extra_params
make

%install
make DESTDIR="$RPM_BUILD_ROOT" install-strip
( cd pyecasound
  %python_compile_opt
  %python_compile
  install *.pyc *.pyo $RPM_BUILD_ROOT%{python_sitepkgsdir}
)
# note! this is needed for automake 1.4 and older
strip --strip-unneeded \
	${RPM_BUILD_ROOT}/%{prefix}/bin/ecasound \
	${RPM_BUILD_ROOT}/%{prefix}/bin/ecaconvert \
	${RPM_BUILD_ROOT}/%{prefix}/bin/ecafixdc \
	${RPM_BUILD_ROOT}/%{prefix}/bin/ecanormalize \
	${RPM_BUILD_ROOT}/%{prefix}/bin/ecaplay \
	${RPM_BUILD_ROOT}/%{prefix}/bin/ecasignalview \
	${RPM_BUILD_ROOT}/%{prefix}/lib/libecasound.a \
	${RPM_BUILD_ROOT}/%{prefix}/lib/libecasoundc.a \
	${RPM_BUILD_ROOT}/%{prefix}/lib/libkvutils.a

# ---
# files sections (main)

%files
%defattr(-, root, root)
%doc NEWS README INSTALL BUGS Documentation examples
%doc /usr/local/man/man1/ecasound.1
%doc /usr/local/man/man1/ecatools.1
%doc /usr/local/man/man1/ecasound-iam.1
%doc /usr/local/man/man5/ecasoundrc.5
/usr/local/bin/ecasound
/usr/local/bin/ecaconvert
/usr/local/bin/ecafixdc
/usr/local/bin/ecamonitor
/usr/local/bin/ecanormalize
/usr/local/bin/ecaplay
/usr/local/bin/ecasignalview
%config /usr/local/share/ecasound

# ---
# files sections (devel)

%files devel
%defattr(-, root, root)
/usr/local/bin/libecasound-config
/usr/local/include/kvutils
/usr/local/include/libecasound
/usr/local/lib/libecasound.la
/usr/local/lib/libecasound.a
/usr/local/lib/libkvutils.la
/usr/local/lib/libkvutils.a

# ---
# files sections (libecasoundc)

%files -n libecasoundc
%defattr(-, root, root)
/usr/local/bin/libecasoundc-config
/usr/local/include/libecasoundc
/usr/local/lib/libecasoundc.la
/usr/local/lib/libecasoundc.a

# ---
# files sections (pyecasound)

%files -n pyecasound
%defattr(644,root,root,755)
%attr(755,root,root) %{python_sitepkgsdir}/*.so
%{python_sitepkgsdir}/*.pyo
%{python_sitepkgsdir}/*.pyc

# ---
# changelog

%changelog
* Thu Oct 17 2002 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- added the -devel package
- fixed the build procedure to handle static builds

* Wed Oct 16 2002 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- removed all shared libraries and subpackages containing 
  them
- ecamonitor binary added to main package

* Sat Oct 05 2002 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- changed libecasoundc versioning back to normal libtool style

* Thu Apr 25 2002 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- libraries put to separate subpackages, interface 
  version numbers code to library names
- ecasound-config renamed to libecasound-config
- ecasoundc-config renamed to libecasoundc-config
- plugin install dir changed from prefix/lib/ecasound-plugins
  to prefix/lib/libecasoundX-plugins
- 'contrib' directory removed
- ecasound-plugins subpackage renamed to libecasoundX-plugins

* Mon Oct 01 2001 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- dropped the hardcoded python module path from configure
  argument list

* Wed Jan 17 2001 Kai Vehmanen <kaiv@wakkanet.fi>
- python subpackage config (thanks to wrobell / PLD Linux!)

* Sat Dec 06 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- contrib and examples directories added to docs
- ecasoundc-config added
- libecasoundc added (C implementation of ECI)
- a new package: pyecasound

* Sat Nov 25 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- ecasignalview added to the package.

* Thu Aug 31 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- Added /etc/ld.so.conf modification script.
- Added DESTDIR to %install.

* Wed Aug 30 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- 'ecasound-config' script added.

* Sun Aug 20 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- All Qt-related stuff removed.

* Wed Jul 06 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- Added the -plugins package.

* Wed Jun 07 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- ecaconvert added to the package.

* Mon Jun 05 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- Renamed ecatools programs.

* Mon Apr 15 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- Removed dynamic linking to ALSA libraries. You 
  can get ALSA support by recompiling the source-RPM
  package.

* Mon Feb 10 2000 Kai Vehmanen <kaiv@wakkanet.fi>
- Added libqtecasound to ecasound-qt.

* Mon Nov 09 1999 Kai Vehmanen <kaiv@wakkanet.fi>
- A complete reorganization. Ecasound distribution is now 
  divided to three RPMs: ecasound, ecasound-qt and ecasound-devel.

* Mon Nov 08 1999 Kai Vehmanen <kaiv@wakkanet.fi>
- As Redhat stopped the RHCN project, so these rpms 
  are again distributed via Redhat's contrib service
- You can also get these from http://ecasound.seul.org/download

* Sun Aug 15 1999 Kai Vehmanen <kaiv@wakkanet.fi>
- Initial rhcn release.
