#ifndef _AUDIOFX_ANALYSIS_H
#define _AUDIOFX_ANALYSIS_H

#include <vector>
#include <string>

#include "samplebuffer_iterators.h"
#include "audiofx.h"

/**
 * Virtual base for signal analyzers.
 * @author Kai Vehmanen
 */
class EFFECT_ANALYSIS : public EFFECT_BASE {

 public:

  virtual void set_parameter(int param, parameter_type value) { }
  virtual parameter_type get_parameter(int param) const { return(0.0); }

  virtual string parameter_names(void) const { return(""); }

  virtual ~EFFECT_ANALYSIS(void) { }
};

/**
 * Effect for analyzing sample volume.
 * @author Kai Vehmanen
 */
class EFFECT_ANALYZE : public EFFECT_ANALYSIS {

  mutable vector<unsigned long int> num_of_samples; // number of samples processed
  mutable vector<vector<unsigned long int> > ranges;
  static const int range_count = 16;

  mutable parameter_type max;
  SAMPLE_ITERATOR_CHANNELS i;
  
 public:

  parameter_type max_multiplier(void) const;
    
  virtual string name(void) const { return("Volume-analyze"); }

  virtual void init(SAMPLE_BUFFER *insample);
  virtual void process(void);
  virtual string status(void) const;
  
  EFFECT_ANALYZE* clone(void)  { return new EFFECT_ANALYZE(*this); }
  EFFECT_ANALYZE* new_expr(void)  { return new EFFECT_ANALYZE(); }
  EFFECT_ANALYZE (void);
};

/**
 * Calculates DC-offset.
 * @author Kai Vehmanen
 */
class EFFECT_DCFIND : public EFFECT_ANALYSIS {

private:

  vector<parameter_type> pos_sum;
  vector<parameter_type> neg_sum;
  vector<parameter_type> num_of_samples;

  SAMPLE_SPECS::sample_type tempval;
  SAMPLE_ITERATOR_CHANNELS i;

public:

  parameter_type get_deltafix(int channel) const;
    
  virtual string name(void) const { return("DC-Find"); }
  virtual string description(void) const { return("Calculates the DC-offset."); }

  virtual void init(SAMPLE_BUFFER *insample);
  virtual void process(void);
  virtual string status(void) const;

  EFFECT_DCFIND* clone(void)  { return new EFFECT_DCFIND(*this); }
  EFFECT_DCFIND* new_expr(void)  { return new EFFECT_DCFIND(); }
  EFFECT_DCFIND (void);
};

#endif
