#ifndef _ECA_OBJECT_MAP_H
#define _ECA_OBJECT_MAP_H

#include <string>
#include <map>

#include "dynamic-object.h"

/**
 * Dynamic register for various objects and their id-strings
 *
 * @author Kai Vehmanen
 */
class ECA_OBJECT_MAP {

 public:

  /**
   * Register a new effect.
   */
  virtual void register_object(const string& id_string, DYNAMIC_OBJECT* object) = 0;

  /**
   * Register default objects.
   */
  virtual void register_default_objects(void) = 0;
};

#endif
