#ifndef _ECA_CONTROLLER_MAP_H
#define _ECA_CONTROLLER_MAP_H

#include <string>
#include <map>

#include "ctrl-source.h"
#include "eca-object-map.h"

/**
 * Dynamic register for controller sources
 *
 * @author Kai Vehmanen
 */
class ECA_CONTROLLER_MAP : public ECA_OBJECT_MAP {

 public:

  static map<string, DYNAMIC_OBJECT*> object_map;
  static map<string, string> object_prefix_map;

  /**
   * Register a new controller
   */
  void register_object(const string& id_string, DYNAMIC_OBJECT* object);

  /**
   * Register default controllers
   */
  void register_default_objects(void);
};

#endif

