#ifndef _ECA_CHAINOP_MAP_H
#define _ECA_CHAINOP_MAP_H

#include <vector>
#include <string>
#include <map>

#include <kvutils.h>

#include "eca-chain.h"
#include "audioio.h"

#include "eca-error.h"

/**
 * Dynamic register for chain operator ids
 * @author Kai Vehmanen
 */
class ECA_CHAINOP_MAP {

 public:

  static map<string, CHAIN_OPERATOR*> chainop_map;
  static map<string, string> chainop_prefix_map;

  /**
   * Register a new effect.
   */
  static void register_chain_operator(const string& id_string,
				      CHAIN_OPERATOR* chainops);

  /**
   * Register default effects.
   */
  static void register_default_chainops(void);
};

#endif
