.TH "ecasound-iam" "5" "22\&.11\&.1999" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecasound-iam \- ecasound interactive mode
.SH "SYNOPSIS" 
.PP 
.SH "DESCRIPTION" 
.PP 
Ecasound library can be controlled with simple commands\&. 
This is called the interactive-mode\&. All programs linked
to ecasound library can use this facility\&. 
.PP 
Notice! Hyphens and underlines are both accepted in
command names (ie\&. c-add and c_add both work)\&.
.PP 
.SH "GENERAL" 
.IP "quit, q" 
Quit ecasound session\&. What this means in practice depends on the 
client (library throws an exception)\&.
.IP 
.IP "start, t" 
Processing is started (play)\&.
.IP 
.IP "stop, s" 
Stop processing\&. 
.IP 
.IP "debug \'debug-level\'" 
Set debug level to \'debug-level\'\&. Notice that client programs can
reimplement the debug routines\&.
.PP 
.IP "help\', \'h\'" 
Help!
.PP 
.IP 
.SH "GLOBAL" 
.IP 
.PP 
.IP "rewind \'time-in-seconds\', rw \'time-in-seconds\'" 
Rewind the current position by \'time-in-seconds\' seconds\&.
.PP 
.IP "forward \'time-in-seconds\', fw \'ttime-in-seconds\'" 
The current position is forwarded by \'time-in-seconds\' seconds\&.
.PP 
.IP "setpos \'time-in-seconds\'" 
Sets the current position to \'time-in-seconds\' seconds from the
beginning\&.
.PP 
.IP "status\',\'st\',\'u\'" 
General status info\&.
.PP 
.IP 
.SH "DIRECT ARGUMENTS" 
One powerful feature of interactive-mode is that it
understands ecasound\'s command-line syntax directly\&. This 
is often the easiest way to add effects and files\&. For instance,
command "-efb:400,200" means that a bandpass filter is added 
to the currently selected chainsetup-chains combination, with
initial parameters 400 (center frequency) and 200 (width in Hz)\&.
.IP 
.SH "CHAINSETUPS" 
Chainsetup is the central data object\&. All other objects (inputs,
outputs, chains, etc) are connected to some chainsetup\&. There can be 
many chainsetups but only one can be connected\&. Similarly only
one chainsetup can be selected\&. If not otherwise specified operations 
are done on the selected chainsetup\&. Some operations also require
that selected chainsetup is not connected\&.
.IP 
.IP "cs-add \'name\'" 
Add a new chainsetup with name \'name\'\&. \'name\' is now 
the selected chainsetup\&.
.PP 
.IP "cs-remove" 
Remove currently selected chainsetup\&.
.PP 
.IP "cs-select \'name\'" 
Select chainsetup \'name\'\&.
.PP 
.IP "cs-load \'filename\'" 
Add a new chainsetup by loading it from file \'filename\'\&. 
\'filename\' is now the selected chainsetup\&.
.PP 
.IP "cs-save" 
Save currently selected chainsetup to file\&. If chainsetup was loaded
from a file, it\'s saved to the same file\&. If it doesn\'t have a default
filename, it\'s saved to "chainsetup_name\&.ecs"\&.
.PP 
.IP "cs-save-as \'filename\'" 
Save currently selected chainsetup to file \'filename\'\&.
.PP 
.IP "cs-edit" 
Currently selected chainsetup is saved to a temporary file\&. This
file is loaded to an external editor (see ecasoundrc(5))\&. After
editing, the chainsetup is loaded back to ecasound\&.
.PP 
.IP "cs-connect" 
Connect currently selected chainsetup to engine\&. Only one chainsetup
can be connected at a time\&.
.PP 
.IP "cs-disconnect" 
Disconnect currently connected chainsetup\&.
.PP 
.IP "cs-length \'seconds\'" 
Set processing time in seconds (doesn\'t have to be an integer 
value)\&.
.PP 
.IP "cs-loop" 
Enable looping\&. When processing is finished, engine will start 
again from the initial position\&.
.PP 
.IP "cs-set" 
Interpret general chainsetup parameters like for example
"-b" (buffersize), "-m" (mixmode), "-n" (name), etc\&. 
See ecasound(1) for more info\&.
.PP 
.IP "cs-format \'bits,channels,sample_rate\'" 
Set the default sample parameters for currently selected chainsetup\&. 
For example cd-quality audio would be "16,2,44100"\&. This does the
same as command-line argument "-f" (see ecasound(1))\&.
.PP 
.IP "cs-status, cstatus, cs, a" 
Print status info about all chainsetups\&.
.IP 
.SH "CHAINS" 
Chain is a simple signal flow abstraction\&. Every chain has one input
and one output\&. All chain operators and their controllers are attached
to chains\&. Chain can be muted, unmuted and it can be bypassed\&.
If not otherwise stated, all operations are done to currently selected
chainsetup\&.
.IP 
.IP "c-add \'cname1,\&.\&.\&.,cnameN\'" 
Add chains\&. Added chains are automatically selected\&.
.PP 
.IP "c-select \'cname1,\&.\&.\&.,cnameN\'" 
Select chains\&.
.PP 
.IP "c-select-all" 
Select all chains\&.
.PP 
.IP "c-remove" 
Remove selected chains\&.
.PP 
.IP "c-clear" 
Clear selected chains by removing all chain operators and controllers\&.
Doesn\'t change how chains are connected to inputs and outputs\&.
.PP 
.IP "c-name \'new_name\'" 
Rename selected chains\&. When using this command, only one chain must
selected\&.
.PP 
.IP "c-muting" 
Toggle chain muting\&. When chain is muted, all data that goes through is muted\&.
.PP 
.IP "c-bypass" 
Toggle chain bypassing\&. When chain is bypassed, sample data is passed 
through untouched\&.
.PP 
.IP "c-forward \'time_in_seconds\', c-fw \'time_in_seconds\'" 
Inputs and outputs connected to selected chains are forwarded 
by \'time-in-seconds\' seconds\&. Time should be given as a floating 
point value (eg\&. 0\&.001 is the same as 1ms)\&. If audio objecst are
connected to multiple selected chains, they will be forwarded multiple
times\&.
.PP 
.IP "c-rewind \'time_in_seconds\', c-rw \'time_in_seconds\'" 
Inputs and outputs connected to selected chains are rewinded by
\'time-in-seconds\' seconds\&. Time should be given as a floating 
point value (eg\&. 0\&.001 is the same as 1ms)\&. If audio objecst are
connected to multiple selected chains, they will be forwarded multiple
times\&.
.PP 
.IP "c-setpos \'time_in_seconds\'" 
Set position of all inputs and outputs connected to selected chains to
\'time_in_seconds\'\&.
.PP 
.IP "c-status" 
Print status info about all chains\&.
.PP 
.IP 
.SH "AUDIO INPUT/OUTPUT OBJECTS" 
If not otherwise stated, all operations are done to currently selected
chainsetup\&.
.IP 
.PP 
.IP "aio-add-input \'input_format_string\'" 
Add a new input object\&. See ecasound(1) man page for more info about 
the argument format (\'-i\' option)\&.
.PP 
.IP "aio-add-output \'output_format_string\'" 
Add a new output object\&. See ecasound(1) man page for more info about 
the argument format (\'-o\' option)\&. 
.PP 
.IP "aio-select \'aobject_name\'" 
Select some audio object\&. \'aobject_name\' is usually a file name, but
not always\&.
.PP 
.IP "aio-index-select \'aobject_index\'" 
Select some audio object based on short index string\&. Especially file
names can be rather long\&. This command can be used to avoid typing
these long names when selecting audio objects\&. \'aobject_index\' format
is "i<number>" for inputs and similarly "o<number>" for outputs\&. 
You can get a list of all audio objects and their indexes with the
\'aio-status\' command\&. 
.PP 
.IP "aio-attach" 
Attach currently selected audio object to all selected chains\&.
.PP 
.IP "aio-remove" 
Remove currently selected audio object\&. 
.PP 
.IP "aio-status" 
Audio object status (index strings, position, length, etc)\&.
.PP 
.IP "aio-forward \'time_in_seconds\', aio-fw \'time_in_seconds\'" 
Selected audio object is forwarded by \'time-in-seconds\' seconds\&. 
Time should be given as a floating point value (eg\&. 0\&.001 is the 
same as 1ms)\&.
.PP 
.IP "aio-rewind \'time_in_seconds\', aio-rw \'time_in_seconds\'" 
Selected audio object is rewinded by \'time-in-seconds\' seconds\&. 
Time should be given as a floating point value (eg\&. 0\&.001 is the 
same as 1ms)\&.
.PP 
.IP "aio-setpos \'time_in_seconds\'" 
Set audio object position to \'time_in_seconds\'\&.
.PP 
.IP "aio-wave-edit" 
Currently selected audio object is loaded into an external
wave editor (see ecasoundrc(5))\&.
.PP 
.IP 
.SH "CHAIN OPERATORS" 
Chain operators are used to process and analyze sample data\&.
Controllers are used to control individual chain operator parameters\&.
Both types of objects are attached to chains\&. If not otherwise stated,
currently selected chainsetup and chains are used\&. Also, \'chainop_id\' 
and \'param_id\' are used to selected chain operators and their
parameters\&. First valid value for these parameters is 1\&.
.IP 
.IP "cop-add \'cop_format_string\'" 
Add a new chain operator\&. Argument format is
"-<id_string>:par1,\&.\&.\&.,parN"\&. See ecasound(1) man page for more 
info\&.
.PP 
.IP "cop-remove \'chainop_id\'" 
Remove chain operator\&.
.PP 
.IP "cop-add-controller \'copc_format_string\'" 
Add a new controller and attach it to currently selected chain 
operator\&. Argument format is "-<id_string>:<param_id>,<range_low>,
<range_high>,par1,\&.\&.\&.,parN"\&.  See ecasound(1) man page for more 
info\&.
.PP 
.IP "cop-set \'chainop_id, param_id, value\'" 
Change the value of a single chain operator parameter\&. Unlike other
chain operator commands, this can also be used during processing\&.
.PP 
.IP "cop-remove-controller \'param_id\'" 
Remove the controller that is attached to the currently selected chain
operator\&.
.PP 
.IP "cop-status" 
Info about chain operator status\&.
.PP 
.IP 
.SH "SEE ALSO" 
.IP 
ecasound(1), qtecasound (1), ecatools (1), ecasoundrc(5)
.IP 
.SH "AUTHOR" 
.IP 
Kai Vehmanen, <kaiv@wakkanet\&.fi>
.IP 
