#ifndef _ECA_MAIN_H
#define _ECA_MAIN_H

#include <vector>
#include <string>
#include <ctime>
#include <pthread.h>

#include <kvutils.h>

#include "eca-session.h"
#include "eca-chainsetup.h"
#include "eca-chain.h"
#include "samplebuffer.h"
#include "audioio.h"
#include "audiofx.h"
// #include "audiogate.h"

extern COMMAND_QUEUE ecasound_cqueue;

class ECA_PROCESSOR {

private:

  ECA_SESSION* eparams;
  pthread_t chain_thread;

  bool finished_result;
  
  bool multitrack_sync_phase;
  bool rt_infiles, rt_outfiles;
  
  string st_info_string;
  bool end_request;

  // ---
  // Pointers to active chainsetup
  // ---
  ECA_CHAINSETUP* csetup;
  vector<AUDIO_IO_DEVICE*>* inputs;
  vector<AUDIO_IO_DEVICE*>* outputs;
  vector<CHAIN*>* chains;

  unsigned char tempvsb;
  unsigned char tempvsip;
  unsigned char tempvecp;
  unsigned char tempveip;

  double current_position(void); // seconds, uses the master_input
  void set_position(double seconds);
  void set_position(int seconds) { set_position((double)seconds); }
  void change_position(int seconds);

  void start(void);
  void start_synced(void);
  void stop(void);
    
  void interprete_cqueue(void);

  void init_status_variables(void);
  void init_mix_method(void);
  void init_pointers(void);

  void mix_to_chains(void);
  void mix_from_chains(void);

  bool is_chain_enabled(const string& name);
  void enable_chain(const string& cname);
  void disable_chain(const string& cname);

  void exec_normal_iactive(void);
  void exec_normal_passive(void);
  void exec_simple_iactive(void);
  void exec_simple_passive(void);
  void exec_mthreaded_iactive(void);
  void exec_mthreaded_passive(void);
  bool finished(void);

  vector<AUDIO_IO_DEVICE*>::const_iterator adev_citer;
  vector<AUDIO_IO_DEVICE*>::size_type adev_sizet;
  vector<SAMPLE_BUFFER>::const_iterator audioslot_citer;
  vector<SAMPLE_BUFFER>::size_type audioslot_sizet;
  vector<CHAIN*>::const_iterator chain_citer;
  vector<CHAIN*>::iterator chain_iter;
  vector<CHAIN*>::size_type chain_sizet;
  vector<CHAIN_OPERATOR*>::const_iterator chainop_citer;
  vector<CHAIN_OPERATOR*>::size_type chainop_sizet;

 public:

  void exec(void);
  void init(void);

  ECA_PROCESSOR(ECA_SESSION* eparam);
  ~ECA_PROCESSOR(void);

 private:

  ECA_PROCESSOR& operator=(const ECA_PROCESSOR& x) { return *this; }
};

void *mthread_process_chains(void* ecaparams);

#endif






