// ------------------------------------------------------------------------
// eca-region.cpp: Base class for handling regions.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <cmath>

#include "eca-region.h"
#include "samplebuffer.h"

ECA_REGION::ECA_REGION(void) {
  region_active_rep = false;
  region_looping_rep = false;
  region_sfx_control_rep = false;

  region_start_pos = 0;
  region_end_pos = 0;
}

void ECA_REGION::region_start_pos_in_seconds(double value) {
  region_start_pos = (long int)ceil(value * 
				    SAMPLE_BUFFER::sample_rate);
}

void ECA_REGION::region_end_pos_in_seconds(double value) {
  region_end_pos = (long int)ceil(value * 
				  SAMPLE_BUFFER::sample_rate);
}

double ECA_REGION::region_start_pos_in_seconds(void) const {
  return(region_start_pos / SAMPLE_BUFFER::sample_rate);
}

double ECA_REGION::region_end_pos_in_seconds(void) const {
  return(region_end_pos / SAMPLE_BUFFER::sample_rate);
}

void ECA_REGION::region_start_pos_in_samples(long int value) {
  region_start_pos = value;
}

void ECA_REGION::region_end_pos_in_samples(long int value) {
  region_end_pos = value;
}

long int ECA_REGION::region_start_pos_in_samples(void) const {
  return(region_start_pos);
}

long int ECA_REGION::region_end_pos_in_samples(void) const {
  return(region_end_pos);
}





