#include <string>

#include <kvutils.h>

#include "eca-comhelp.h"

static const string ecasound_parameter_help_rep = 

string("USAGE: (qt)ecasound [general options] [chain setup] {inputs] [outputs] \n") +
"    -c                       set interactive mode \n" +
"    -d:debug_level           show debug info \n" + 
"    -q                       quiet mode, no output \n" +
"    -s[:]file                load chainsetup from 'file' \n" +
// ---------------------------------------------------------------------
" \n" +
"    -b:buffersize            size of sample buffer in samples \n" +
"    -m:mixmode               mixmode; auto (default), simple, normal, \n" +
"                             mthreaded \n" +
"    -n:name                  set chainsetup name \n" +
"    -r                       raise runtime prioritary \n" +
"    -x                       truncate outputs \n" +
"    -z:feature               enable feature 'feature' \n" +
" \n" +
"    -a:name1, name2, ...     set active chains ('all' reserved) \n" +
"    -f:bits,channels,srate   file format (for all following inputs/outputs) \n" +
"    -i[:]infile              specify a new infile (assigned to active chains) \n" +
"    -o[:]outfile             specify a new outfile (assigned to active chains) \n" +
// ---------------------------------------------------------------------
" \n" +
"    -ps:preset_name          insert a single-chain preset \n" +
"    -ea:amplify_%, cmax      amplify_% (100% means no change), warns if over \n" +
"                             cmax consecutive clipped samples \n" +
"    -eas:amplify_%           amplify_% (100% means no change) \n" +
"    -ec:c_rate,threshhold    compress (c_rate: -1.0 max. compress, 0.0 no \n" +
"                             effect, >0.0 expand; doesn't affect if volume \n" +
"                             under threshhold) \n" +
"    -eca:peak-%, rel_time,   advanced compressor \n" +
"     fastrate, crate          \n" +
"    -ef1:center_freq, width  resonant bandpass filter \n" +
"    -ef2:cutof_freq          simple lowpass filter \n" +
"    -ef3:cutoff_freq, reso,  resonant lowpass filter \n" +
"         gain \n" +
"    -efb:center_freq,width   bandpass filter \n" +
"    -efh:cutoff_freq         highpass filter \n" +
"    -efi:delay_in_sampl,rad  inverse comb filter \n" +
"    -efl:cutoff_freq         lowpass filter \n" +
"    -efr:center_freq,width   bandreject filter \n" +
"    -efs:center_freq,width   resonator filter \n" +
"    -enm:threshold_level_%,  noise gate, mono \n" +
"         th_time, attack,    ([0,1], ms, ms, ms, ms) \n" +
"         hold, release        \n" +
"    -epp:l_r_balance         normal pan (0 = left, 100 = right) \n" +
"    -etd:delay_time,mode,    delay (mode: 0 = normal,  \n" +
"         number_of_delays    1 = surround, 2 = stereo-spread) \n" +
"         mix_%%               \n" +
"    -etf:delay_time          fake stereo (delay 1-40ms) \n" +
"    -etr:reverb_time,mode,   reverb (mode: 0 = normal,  \n" +
"        feedback_%%          1 = surround) \n" +
"    -ev                      analyze/maximize volume (non-realtime) \n" +
"    -ezf                     find optimal value for DC-fix \n" +
"    -ezx:left,right          adjust DC \n" +
"\n" +
"    -gc:beg.time, len         time crop gate (gate open for 'len' seconds  \n" +
"                              starting from 'beg.time') \n" +
"    -ge:othreshold%, cthold%, threshold gate (open when volume goes over \n" +
"        volume_mode           'othreshold' and closes when it drops below \n" + 
"                              'cthold'. If 'value_mode' is 'rms', use \n" +
"                              average RMS volume, otherwise use peak \n" +
" \n" +
"    -kos:fx_param,low_range,  sine-oscillator \n" +
"         high_rng,freq,i_phase   \n" +
"    -kf:fx_param, low_range,  file envelope (generic oscillator) \n" +
"        genosc_number        \n" +
"    -km:fx_param, low_range,  MIDI controlled envelope \n" +
"        high_rng, controller, \n" +
"        channel \n\n\n";

const string& ecasound_parameter_help(void) {
  return(ecasound_parameter_help_rep);
}

// ---------------------------------------------------------------------
//    \n \
//      -y:start_pos, end_pos    region start and end in seconds \n \
//      -yl                      enable region looping \n \
//      -yp                      enable region sfx control \n \
// ---------------------------------------------------------------------
//
//
//    string output;
//    output += "USAGE: (qt)ecasound [general options] [chain setup] {inputs] [outputs]";
//    output += "\n";
//    output += "\n   -c                       set interactive mode";
//    output += "\n   -d:debug_level           show debug info";
//    output += "\n   -q                       quiet mode, no output";
//    output += "\n   -s[:]file                load chainsetup from 'file'";
//  // ---------------------------------------------------------------------
//    output += "\n";
//    output += "\n   -b:buffersize            size of sample buffer in samples";
//    output += "\n   -m:mixmode               mixmode; auto (default), simple, normal,";
//    output += "\n                            mthreaded";
//    output += "\n   -n:name                  set chainsetup name";
//    output += "\n   -r                       raise runtime prioritary";
//    output += "\n   -x                       truncate outputs";
//    output += "\n   -z:feature               enable feature 'feature'";
//  // ---------------------------------------------------------------------
//  //    output += "\n";
//  //    output += "\n   -y:start_pos, end_pos    region start and end in seconds";
//  //    output += "\n   -yl                      enable region looping";
//  //    output += "\n   -yp                      enable region sfx control";
//  // ---------------------------------------------------------------------
//    output += "\n";
//    output += "\n   -a:name1, name2, ...     set active chains ('all' reserved)";
//    output += "\n   -f:bits,channels,srate   file format (for all following inputs/outputs)";
//    output += "\n   -i[:]infile              specify a new infile (assigned to active chains)";
//    output += "\n   -o[:]outfile             specify a new outfile (assigned to active chains)";
//  // ---------------------------------------------------------------------
//    output += "\n";
//    output += "\n   -ps:preset_name          insert a single-chain preset";
//    output += "\n   -ea:amplify_%, cmax      amplify_% (100% means no change), warns if over";
//    output += "\n                            cmax consecutive clipped samples";
//    output += "\n   -eas:amplify_%           amplify_% (100% means no change)";
//    output += "\n   -ec:c_rate,threshhold    compress (c_rate: -1.0 max. compress, 0.0 no";
//    output += "\n                            effect, >0.0 expand; doesn't affect if volume";
//    output += "\n                            under threshhold)";
//    output += "\n   -eca:peak-%, rel_time,   advanced compressor";
//    output += "\n    fastrate, crate         ";
//    output += "\n   -ef1:center_freq, width  resonant bandpass filter";
//    output += "\n   -ef2:cutof_freq          simple lowpass filter";
//    output += "\n   -ef3:cutoff_freq, reso,  resonant lowpass filter";
//    output += "\n        gain";
//    output += "\n   -efb:center_freq,width   bandpass filter";
//    output += "\n   -efh:cutoff_freq         highpass filter";
//    output += "\n   -efi:delay_in_sampl,rad  inverse comb filter";
//    output += "\n   -efl:cutoff_freq         lowpass filter";
//    output += "\n   -efr:center_freq,width   bandreject filter";
//    output += "\n   -efs:center_freq,width   resonator filter";
//    output += "\n   -enm:threshold_level_%,  noise gate, mono";
//    output += "\n        th_time, attack,    ([0,1], ms, ms, ms, ms)";
//    output += "\n        hold, release       ";
//    output += "\n   -epp:l_r_balance         normal pan (0 = left, 100 = right)";
//    output += "\n   -etd:delay_time,mode,    delay (mode: 0 = normal, ";
//    output += "\n        number_of_delays    1 = surround, 2 = stereo-spread)";
//    output += "\n        mix_%%              ";
//    output += "\n   -etf:delay_time          fake stereo (delay 1-40ms)";
//    output += "\n   -etr:reverb_time,mode,   reverb (mode: 0 = normal, ";
//    output += "\n       feedback_%%          1 = surround)";
//    output += "\n   -ev                      analyze/maximize volume (non-realtime)";
//    output += "\n   -ezf                     find optimal value for DC-fix";
//    output += "\n   -ezx:left,right          adjust DC";
//  // ---------------------------------------------------------------------
//    output += "\n";
//    output += "\n   -gc:beg.time, len         time crop gate (gate open for 'len' seconds ";
//    output += "\n                             starting from 'beg.time')";
//    output += "\n   -ge:othreshold%, cthold%, threshold gate (open when volume goes over";
//    output += "\n       volume_mode           'othreshold' and closes when it drops below"; 
//    output += "\n                             'cthold'. If 'value_mode' is 'rms', use";
//    output += "\n                             average RMS volume, otherwise use peak";
//  // ---------------------------------------------------------------------
//    output += "\n";
//    output += "\n   -kos:fx_param,low_range,  sine-oscillator";
//    output += "\n        high_rng,freq,i_phase  ";
//    output += "\n   -kf:fx_param, low_range,  file envelope (generic oscillator)";
//    output += "\n       genosc_number       ";
//    output += "\n   -km:fx_param, low_range,  MIDI controlled envelope";
//    output += "\n       high_rng, controller,";
//    output += "\n       channel";
  
//    output += "\n\n";



