#ifndef _GENERIC_OSCILLATOR_H
#define _GENERIC_OSCILLATOR_H

#include <fstream>
#include <vector>
#include <string>

#include "samplebuffer.h"
#include "oscillator.h"

class GENERIC_OSCILLATOR : public OSCILLATOR {
  //
  // A generic oscillator. Oscillator value is changed linearly between 
  // envelope points. These points are spesified in an ascii conf
  // file. 
  //

  bool preset_found;
  bool linear;
  vector<double> ienvelope;
  double L; // loop length in seconds
  double pdistance; // distance of two points in seconds
  double pcounter; // current position in seconds
  size_t current;
  double curval;
  int preset;

  void read_envelope(const string& filename, int preset_number);
  
 public:

  // Functions returning info about effect and its parameters.
  // ---
  void set_parameter(int param, double value) { }
  double get_parameter(int param) const;

  double value(void);
  string label(void) { return("Generic oscillator"); }
  string id_string(void) const { return("kf"); }
  int number_of_params(void) const { return(1); }
  
  GENERIC_OSCILLATOR(double step, double freq, int preset_number,
		       const string& filename);
  virtual ~GENERIC_OSCILLATOR (void);
};

#endif


