#ifndef _FILEIO_MMAP_H
#define _FILEIO_MMAP_H

#include "eca-fileio.h"

class ECA_FILE_IO_MMAP : public ECA_FILE_IO {
  // --
  // Class that provides file-io and buffering functions for 
  // other classes. Uses mmap for file i/o.
  // --

 private:

  int f1;
  long int internal_bsize;
  long int internal_bindex;
  unsigned char* internal_buffer;
  long int bytes_rep;

  long int fposition, flength;
  long int mmap_low, mmap_high;

  int fiommap_id;

  bool file_ready;
  bool file_ended;
  bool switch_buffer;

  string mode_rep;
   
 public:


  // --
  // Open/close routines
  // ---
  void open_file(const string& fname, 
		 const string& fmode, 
		 bool handle_errors = true);
  void open_stdin(void) { }
  void open_stdout(void) { }
  void close_file(void);

  // --
  // Normal file operations
  // ---
  void read_to_buffer(void* obuf, long int bytes);
  void read_to_buffer_old(void* obuf, long int bytes);
  void write_from_buffer(void* obuf, long int bytes);

  void set_file_position(long int newpos) { set_file_position(newpos,true); }
  void set_file_position(long int newpos, bool seek);
  void set_file_position_advance(long int fw);
  void set_file_position_end(void);
  long int get_file_position(void);
  long int get_file_length(void);

  // --
  // Status
  // ---
  bool is_file_ready(void);
  bool is_file_error(void);
  bool is_file_ended(void);
  long int file_bytes_processed(void);
  const string& file_mode(void) { return(mode_rep); }

  ECA_FILE_IO_MMAP(void) {
    internal_bsize = 0;
    switch_buffer = false;
  }
  ~ECA_FILE_IO_MMAP(void);
};

#endif
