#ifndef _AUDIOIO_RAW_H
#define _AUDIOIO_RAW_H

#include <string>
#include "samplebuffer.h"

#include "eca-fileio.h"
#include "eca-fileio-mmap.h"
#include "eca-fileio-stream.h"

class RAWFILE : public AUDIO_IO_DEVICE {
  //
  // Represent a raw/headerless audio file. 
  //
  // Sample layout:
  //     - host byte-order for 16bit samples
  //     - for stereo samples, left channels is put first
  //

  ECA_FILE_IO* fio;
  bool double_buffering_rep;

  RAWFILE(const RAWFILE& x) { }
  RAWFILE& operator=(const RAWFILE& x) { return *this; }

  void position_in_samples_hook(void);
  void set_length_in_bytes(void);

 public:

  void   get_sample(SAMPLE_BUFFER* t);
  void   put_sample(SAMPLE_BUFFER* t);

  void open_device(void);
  void close_device(void);
    
  inline bool is_realtime(void) const { return(false); }

  RAWFILE (const string& name, const SIMODE mode, const AIO_PARAMS& format, int bsize, bool double_buffering = false);
  RAWFILE::~RAWFILE(void);
    
  RAWFILE* clone(void) { return new RAWFILE(*this); }    
};

#endif









