#ifndef _AUDIOIO_MP3_H
#define _AUDIOIO_MP3_H

#include <string>
#include "audioio.h"
#include "samplebuffer.h"

class MP3FILE : public AUDIO_IO_DEVICE {
//
//  Interface to MP3 files. Uses FIFO pipes and mpg123.
//
    bool is_open;
    int pid_of_child;
    long pcm;
    long int samples_read;

    FILE* fobject;

    void position_in_samples_hook(void);

    long int length_in_bytes(void) const;
    long int curpos(void) const;

    void get_mp3_params(const string& fname);

    MP3FILE(const MP3FILE& x) { }
    MP3FILE& operator=(const MP3FILE& x) { }

    pthread_t mp3_thread;
    void kill_mpg123(void);
    void fork_mpg123(void);
    void fork_lame(void);
    
 public:

    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);

    void open_device(void);
    void close_device(void);
    
    // --
    // Realtime related functions
    // --
    inline bool is_realtime(void) const { return(false); }

    MP3FILE (const string& name, const SIMODE mode, const AIO_PARAMS& format, int bsize);
    MP3FILE::~MP3FILE(void);
    
    //    MP3FILE* new_expr(void) { return new MP3FILE(); }
    MP3FILE* clone(void) { return new MP3FILE(*this); }    
};

void* start_mpg123(void* mcmd);
void* start_lame(void* mcmd);

#endif
