.TH "ecasound" "1" "01\&.09\&.1999" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecasound \- sample editor, multitrack recorder, fx-processor, etc\&.
.PP 
.SH "SYNOPSIS" 
\fBecasound\fP [ general_options ] { [ chain_setup ] [ effect_setup ] [ input_setup ] [ output_setup ] }
.PP 
.SH "DESCRIPTION" 
.PP 
Ecasound is a sound processing application designed for basic
effect processing, mixing, multitrack recording and signal
recycling\&. It supports OSS and ALSA sound drivers, wav, mp3,
aiff, cdda, au, snd, raw and standard file streams (all can be 
used both as inputs and outputs)\&. Effects can be combined both
in series and in parallel, while effect parameters can be
controlled in realtime with oscillators and MIDI controllers\&.
.PP 
.SH "OPTIONS" 
.PP 
Notice that the order of parameters given on the command
line is important!
.PP 
\fBGLOBAL OPTIONS\fP
.IP 
.IP "-c" 
Starts ecasound in interactive mode\&. In interactive mode you can
control ecasound with simple commands ("start", "stop", "pause",
etc\&.)\&.
.IP 
.IP "-d:debug level" 
Set the debug level\&. Default is 0\&.
.IP 
.IP "-q" 
Quiet mode, no output\&.
.IP 
.PP 
\fBCHAINSETUP OPTIONS\fP
.IP 
.IP "-n:name" 
Set the name of chainsetup to \'name\'\&. If not specified, defaults
either to "command-line-setup" or to the file name from which
chainsetup was loaded\&. Whitespaces are not allowed in \'name\'\&.
.IP 
.IP "-s chainsetup-file" 
Create a new chainsetup from the file \'chainsetup-file\' and add
it to the current session\&. Chainsetup can contain inputs, outputs, 
chains, effects, controllers, etc\&. A session, on the other hand, 
contains all the chainsetups\&. Although only one chainsetup can
be active at a time, you can switch between them on-the-fly\&.
.IP 
.PP 
\fBGENERAL\fP
.IP 
.IP "-a:chainname1, chainname2, \&.\&.\&." 
Sets active signal chains\&. All effects, inputs and outputs are assigned to
these chains\&. If there are no -a options given, default chain is used\&.
Chain name \'all\' is reserved and means that all chains are active\&. By giving 
multiple -a options, you can control to which chains effects, inputs and outputs
are assigned to\&. Look at the 
\fBEXAMPLES\fP
section for more detailed info about the usage of this option\&.
.IP 
.IP "-b:buffer size" 
Sets the size of buffer in samples (must be an exponent of 2)\&. This
is quite an important option\&. For real-time processing, you should
set this as low as possible to reduce the processing delay\&. Some
machines can handle buffer values as low as 64 and 128\&. In some
circumstances (for instance when using oscillator envelopes) small
buffer sizes will make envelopes act more smoothly\&. When not processing
in real-time (all inputs and outputs are normal files), values between
512 - 4096 often give better results\&. Default is 1024\&.
.IP 
.IP "-m:mix-mode" 
Force ecasound to use mix mode \'mix_mode\'\&. \'auto\' = automatic (default),
\'simple\' =  only one input/chain/output, \'normal\' = normal single-threaded
mode and \'mthreaded\' = multithreaded mixing\&. In most cases, ecasound is 
able to find out the correct mode automatically\&.
.IP 
.IP "-r" 
Raise process priority\&. Improves realtime performance\&. 
.IP 
.IP "-x" 
Truncate outputs\&. If this isn\'t set, ecasound opens all outputs 
- if format allows it - in readwrite mode\&.
.IP 
.IP "-z:feature" 
Enable \'feature\'\&. Currently only supported feature is \'db\', 
which enables double-buffering with audio inputs that support it\&.
.IP 
.PP 
\fBINPUT/OUTPUT SETUP\fP
.IP " -f:bits,channel,sample-rate" 
Sets active sampling parameters\&. These are used for all following input and
output files or until another -f is spesified\&. If no -f option is
present, ecasound tries to get the parameters from the audio object
(for instance RIFF WAVE header)\&. If no valid sample parameters are
found, defaults are used (16 bits, 2 channels, 44100 samples per
second)\&.
.IP 
.IP "-i input-file-or-device" 
Specifies a new input source\&. It is assigned to the active chains\&.
Assigned multiple inputs to the same chain is currently not possible\&.
The given input can be a normal file or an audio device\&. File format
is determined using the file name extension\&. Currently supported
formats are RIFF WAVE files (\&.wav), audio-cd tracks (\&.cdr), ecasound
ewf-files (\&.ewf), RAW audio data (\&.raw), AIFF (\&.aiff, \&.aif), 
Sun/NeXT audio files (\&.au, \&.snd), MPEG files (\&.mp2,\&.mp3), OSS audio
devices (/dev/dsp*) and ALSA audio/loopback devices (/dev/snd/pcm*, 
alsalb)\&. If no inputs are specified, the first non-option on the
command line (if any) is considered to be a input\&.
.IP 
.IP " -o output-file-or-device" 
Acts in the same way as the -i option\&. If no no outputs are specified,
the default output device is used (see &tilde;/\&.ecasoundrc)\&.
.IP 
\fISPECIAL INPUT/OUTPUT DEVICES\fP
.IP "ALSA devices" 
When using ALSA drivers, in addition to /dev/snd/pcm* files, you can 
also use option syntax \fB-i[:]alsa,card_number,device_number\fP\&.
.IP 
.IP "ALSA loopback device" 
By using the ALSA loopback system, you can grab audio data from any
other ALSA pcm device\&. Option syntax is 
\fB-i[:]alsalb,card_number,device_number,loop_mode\fP\&. Loopmode 
is either \fB"p"\fP for looping a playback device or \fB"c"\fP for
a capture device\&.
.IP 
.IP " Null inputs/outputs " 
If you specify "null" or "/dev/null" as the input or output, 
a null audio device is created\&. This is useful if you just want
to analyze sample data without writing it to a file\&. Of course
you could output to a soundcard device, but that again is slow\&. 
.IP 
.IP "System standard streams" 
You can use standard stream (stdin and stdout) by giving "stdin" 
or "stdout" as the file name\&. The format is the same as with
raw/headerless (\&.raw) audio files\&.
.IP 
.PP 
\fBEFFECT SETUP\fP
.PP 
.IP "-ps:preset_name" 
Insert single-chain preset \'preset_name\' to active chains\&.
See ecasoundrc(5) for info about the preset file\&. 
.PP 
\fISIGNAL ANALYSIS\fP
.PP 
.IP 
.IP "-ev" 
Analyze sample data to find out how much the signal can
be amplified without clipping\&. The resulting percent value
can be used as a parameter to -ea and -eas effects\&. Also prints 
a statistics table containing info about stereo-image and
how different sample values are used\&.
.IP 
.IP "-ezf" 
Find the optimal value for DC-adjusting\&. You can use the result
as a parameter to -ezx effect\&.
.IP 
.PP 
\fIGENERAL SIGNAL PROCESSING ALGORITHMS\fP
.IP "-ea:amplify-%,max-clipped-samples" 
Amplifies signal by amplify-% percent\&. If number of consecutive
clipped samples (resulting sample has the largest amplitude
possible) reaches \'max-clipped-samples\', a warning will be issued\&.
.IP 
.IP "-eas:amplify-%" 
Otherwise like -ea, but doesn\'t warn about clipped samples\&.
.IP 
.IP "-ec:rate,threshold" 
Compressor (a simple one)\&. \'rate\' is the compression rate in
decibels (\'rate\'dB change in input signal causes 1dB change 
in output)\&. \'threshold\' varies between 0\&.0 (silence) and
1\&.0 (max amplitude)\&.
.IP 
.IP "-eca:peak-level-%, release_time, fastrate, rate" 
A more advanced compressor (original algorithm by John S\&. Dyson)\&. 
If you give a value of 0 to any parameter, the default is used\&.
\'peak-level-%\' essentially specifies how hard the peak limiter
is pushed\&.  The default of 69% is good\&. \'release_time\' is given 
in seconds\&. This compressor is very sophisticated, and actually
the release time is complex\&.  This is one of the dominant release 
time controls, but the actual release time is dependent on a lot of 
factors regarding the dynamics of the audio in\&. \'fastrate\' is the 
compression ratio for the fast compressor\&.  This is not really 
the compression ratio\&.  Value of 1\&.0 is infinity to one, while the 
default 0\&.50 is 2:1\&.  Another really good value is special cased in 
the code: 0\&.25 is somewhat less than 2:1, and sounds super smooth\&.
\'rate\' is the compression ratio for the entire compressor chain\&.  
The default is 1\&.0, and holds the volume very constant without many nasty
side effects\&.  However the dynamics in music are severely restricted,
and a value of 0\&.5 might keep the music more intact\&.
.IP 
.IP "-enm:threshold_level_%,th_time,attack,hold,release" 
Noise gate (mono-summed signal used to control the gate)\&. 
When signal amplitude falls below \'threshold_level_%\' percent
(100% means maximum amplitude) the gate is activated\&. If the
signal stays below the threshold for \'th_time\' ms,
it\'s faded out during the attack phase of \'attack\' ms\&.
If the signal raises above the \'threshold_level\' and stays
there over \'hold\' ms the gate is released during \'release\' ms\&.
.IP 
.IP "-epp:right-%" 
Normal pan effect\&. Balance value of 0 means to pan signal fully
left and 100 fully right\&. If the panned signal is
a stereo signal, left and right channels aren\'t mixed together\&.
Use the -f option to force conversion to mono before panning\&.
.IP 
.IP "-ezx:left-dc-fix-value,right-dc-fix-value" 
Adjusts the signal DC by \'dc-fix-value\'\&. Use -ezf to find the
optimal value\&.
.IP 
.PP 
\fITIME-BASED EFFECTS\fP
.IP "-etd:delay_time,surround-mode,number_of_delays,mix-%" 
Delay effect\&. \'delay time\' is the delay time in milliseconds\&.
\'surround-mode\' is a integer with following meanings: 0 = normal, 
1 = surround, 2 = stereo-spread\&. \'number_of_delays\' should be 
obvious\&. Beware that large number of delays and huge delay times 
need a lot of CPU power\&. \'mix-%\' determines how much effected (wet)
signal is mixed to the original\&.
.IP 
.IP "-etr:delay-time,surround-mode,feedback-%" 
Reverb effect\&. \'delay time\' is the delay time in milliseconds\&.
If \'surround-mode\' is \'surround\', reverbed signal moves around the
stereo image\&. \'feedback-%\' determines how much effected (wet)
signal is fed back to the reverb\&.
.IP 
.IP "-etf:delay_time" 
Fake-stereo effect\&. The input signal is summed to mono\&. The
original signal goes to the left channels while a delayd 
version (with delay of \'delay time\' milliseconds) is goes to
the right\&. With a delay time of 1-40 milliseconds this 
adds a stereo-feel to mono-signals\&. 
.IP 
.PP 
\fIFILTER EFFECTS\fP
.IP "-ef1:center_freq, width" 
Resonant bandpass filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-ef3:cutoff_freq, reso, gain" 
Resonant lowpass filter\&. \'cutoffr_freq\' is the filter cutoff
frequency\&. \'reso\' means resonance\&. Usually the best values for
resonance are between 1\&.0 and 2\&.0, but you can use even bigger values\&.
\'gain\' is the overall gain-factor\&. It\'s a simple multiplier (1\&.0 
is the normal level)\&. With high resonance values it often is useful 
to reduce the gain value\&.
.IP 
.IP "-efb:center_freq,width" 
Bandpass filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-efh:cutoff_freq" 
Highpass filter\&. Only frequencies above \'cutoff_freq\' are passed
through\&.
.IP 
.IP "-efi:delay_in_samples,radius" 
Inverse comb filter\&. Allows the spikes of the comb to pass through\&.
The comb consists of \'delay_in_samples/2\' spikes\&. The maximum
value for \'radius\' is 1\&.0\&. The closer it is to the maximum value,
the deeper the dips of the comb\&.
.IP 
.IP "-efl:cutoff_freq" 
Lowpass filter\&. Only frequencies below \'cutoff_freq\' are passed
through\&.
.IP 
.IP "-efr:center_freq,width" 
Bandreject filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-efs:center_freq,width" 
Resonator\&. \'center_freq\' is the center frequency\&. Width is specified
in Hz\&. Basicly just another resonating bandpass filter\&.
.IP 
.PP 
\fBGATE SETUP\fP
.PP 
.IP 
.IP "-gc:start-time,len" 
Time crop gate\&. Initially gate is closed\&. After \'start-time\' seconds
has elapse, gate opens and remains open for \'len\' seconds\&.
.IP 
.IP "-ge:othreshold%, cthold%,volume_mode" 
Threshold gate\&. Initially gate is closed\&. It is opened when volume 
goes over \'othreshold\' percent\&. After this, if volume drops below 
\'cthold\' percent, gate is closed and won\'t be opened again\&. 
If \'value_mode\' is \'rms\', average RMS volume is used\&. Otherwise
peak average is used\&. 
.IP 
.PP 
\fBCONTROL ENVELOPE SETUP\fP
.IP 
Controllers can be used to dynamically change effect parameters
during processing\&. All controllers are attached to the active
(=the last effect/chainop you specified) effect\&. The first 
three parameters are ommon for all controllers\&. \'fx_param\' 
specifies the parameter to be controlled\&. Value \'1\' means 
the first parameter, \'2\' the second and so on\&. \'low_range\' 
and \'high_range\' set the value range\&. You really should see
\fIexample\&.html\fP for some more info\&. 
.IP 
.IP "-kos:fx_param,low_range,high_range,freq,i_phase" 
Sine oscillator with frequency of \'freq\' Hz and initial phase
of \'i_phase\' times pi\&. 
.IP 
.IP "-kf:fx_param,low_range,high_range,genosc_number" 
Generic oscillator\&. \'genosc_number\' is the number of the 
oscillator preset to be loaded\&. The location for the preset
file is taken from \&./ecasoundrc (see \fIecasoundrc(5)\fP\&.
.IP 
.IP "-km:fx_param,low_range,high_range,controller,channel" 
MIDI continuous controller (control change messages)\&. 
Messages on the MIDI-channel \'channel\' that are coming from
controller number \'controller\' are used as the controller
source\&. The MIDI-device is specified in \&./ecasoundrc (see 
\fIecasoundrc(5)\fP\&. Defaults to \fI/dev/midi\fP\&.
.IP 
.PP 
\fBINTERACTIVE MODE\fP
.PP 
The interactive mode of ecasound is launched with the -c option\&. In
this mode, ecasound reacts to the following commands:
.IP "\'quit\', \'q\'" 
Quits ecasound\&.
.IP 
.IP "\'exec\'" 
Ecasound starts the processing engine\&. Normally you don\'t need to use
this\&.
.IP 
.IP "\'end\'" 
Ecasound exits the processing engine, but doesn\'t exit the interactive
mode\&. Normally you don\'t need to use this\&.
.IP 
.IP "\'start\', \'t\'" 
Processing is started (play)\&.
.IP 
.IP "\'stop\', \'s\'" 
Stops processing\&. 
.IP 
.IP "\'debug debug-level\'" 
Set debug level\&.
.IP 
.IP "\'rewind time-in-seconds\', \'rw time-in-seconds\'" 
Rewind the current position by \'time-in-seconds\' seconds\&.
.IP 
.IP "\'forward time-in-seconds\', \'fw time-in-seconds\'" 
The current position is forwarded by \'time-in-seconds\' seconds\&.
.IP 
.IP "\'setpos time-in-seconds\'" 
Sets the current position to \'time-in-seconds\' seconds from the
beginning\&.
.IP 
.IP "\'status\',\'st\',\'u\'" 
General status info\&.
.IP 
.IP "\'cstatus\',\'cs\',\'a\'" 
Status info about the effect chains\&.
.IP 
.IP "\'estatus\', \'es\',\'x\'" 
Status info about effects and controller envelopes\&.
.IP 
.IP "\'fstatus\', \'fs\',\'l\'" 
Status info about open files and devices\&.
.IP 
.IP "\'sfx\'" 
Enable/disable the sound effects section\&.
.IP 
.IP "\'chain chainname\', \'c chainname\'" 
Enable/disable the the chain \'chainname\'\&.
.IP 
.IP "\'loop\'" 
Start/stop looping\&.
.IP 
.IP "\'loop_start seconds_from_start\'" 
Set the start point for looping\&.
.IP 
.IP "loop_end seconds_from_start\'" 
Set the end point for looping\&.
.IP 
.IP "\'load file_name\'" 
Load a chainsetup from file \'file_name\' and set it active\&.
.IP 
.IP "\'save file_name\'" 
Save the active chainsetup to file \'file_name\'\&.
.IP 
.IP "\'help\', \'h\'" 
Help!
.IP 
.PP 
.SH "FILES" 
.PP 
\fI~/\&.ecasoundrc\fP
The default ecasound resource file\&. See \fIecasoundrc(5)\fP 
man page\&.
.PP 
\fI*\&.ews\fP 
Ecasound Wave Stats\&. These files are used to cache
waveform data\&. 
.PP 
\fI*\&.ecs\fP 
Ecasound Chainsetup files\&. Syntax is more or less the
same as with command-line arguments\&.
.PP 
.SH "SEE ALSO" 
.PP 
qtecasound (1), ecatools (1), ecasoundrc(5), "HTML docs in the Documentation subdirectory"
.PP 
.SH "BUGS" 
.PP 
Lots of\&.\&.\&. ;) See the file BUGS\&. If ecasound behaves weirdly, try to
increase the debug level to see what\'s going on\&.
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kaiv@wakkanet\&.fi>
.PP 
