#ifndef _CHAINOP_H
#define _CHAINOP_H

#include <map>
#include <string>

#include "samplebuffer.h"

class CHAIN_OPERATOR {
  //
  // Interface for all chain operator classes. 
  //
 
  bool dynparam_support;
  map<string,int> param_map;
  map<int,string> param_revmap;

 protected:

  void add_parameter(const string& name) { 
    int id = (int)(param_map.size() + 1);
    param_map[name] = id;
    param_revmap[id] = name;
  }

 public:

  int get_parameter_id(const string& name) { return(param_map[name]); }
  const string& get_parameter_name(int id) { return(param_revmap[id]); }
  virtual int number_of_params(void) const { return(param_map.size()); }

  bool support_for_dynamic_parameters(void) const { return(dynparam_support); }
  void support_for_dynamic_parameters(bool t) { dynparam_support = t; }

  virtual void set_parameter(int param, double value) { }
  virtual double get_parameter(int param) { return(0.0); }

  virtual string label(void) = 0;
  virtual string id_string(void) { return(""); }

  virtual void process(SAMPLE_BUFFER* sbuf) {
    sbuf->first();
    //    cerr << "First to effect, left/right: " << sbuf->current_sample()->get_left() << ", "<< sbuf->current_sample()->get_right() << ".\n";
    while(sbuf->is_readable()) {
      process(sbuf->current_sample());
      sbuf->next();
    }
    //    sbuf->first();
    //    cerr << "First after effect, left/right: " << sbuf->current_sample()->get_left() << ", "<< sbuf->current_sample()->get_right() << ".\n";
  }
  virtual void process(SAMPLE_BUFFER::sample_type *) { };
  virtual string status(void) { return(""); }

  virtual CHAIN_OPERATOR* clone(void) = 0;
  virtual ~CHAIN_OPERATOR (void) { }
};

#endif






