#include <string>

#include <kvutils.h>

#include "eca-comhelp.h"

string ecasound_parameter_help(void) {
  MESSAGE_ITEM laite; 
  laite <<  "USAGE: (qt)ecasound [general options] [chain setup] {inputs] [outputs]";
  laite <<  "\n";
  laite <<  "\n   -c                       set interactive mode";
  laite <<  "\n   -d:debug_level           show debug info";
  laite <<  "\n   -q                       quiet mode, no output";
  laite <<  "\n   -s[:]file                load chainsetup from 'file'";
// ---------------------------------------------------------------------
  laite <<  "\n";
  laite <<  "\n   -b:buffersize            size of sample buffer in samples";
  laite <<  "\n   -m:mixmode               mixmode; auto (default), simple, normal,";
  laite <<  "\n                            mthreaded";
  laite <<  "\n   -n:name                  set chainsetup name";
  laite <<  "\n   -r                       raise runtime prioritary";
  laite <<  "\n   -x                       truncate outputs";
// ---------------------------------------------------------------------
  laite <<  "\n";
  laite <<  "\n   -y:start_pos, end_pos    region positions in seconds";
  laite <<  "\n   -yl                      enable region looping";
  laite <<  "\n   -yp                      enable region sfx control";
// ---------------------------------------------------------------------
  laite <<  "\n";
  laite <<  "\n   -a:name1, name2, ...     set active chains ('all' reserved)";
  laite <<  "\n   -f:bits,channels,srate   file format (for all following inputs/outputs)";
  laite <<  "\n   -i[:]infile              specify a new infile (assigned to active chains)";
  laite <<  "\n   -o[:]outfile             specify a new outfile (assigned to active chains)";
// ---------------------------------------------------------------------
  laite <<  "\n";
  laite <<  "\n   -ps:preset_name          insert a single-chain preset";
  laite <<  "\n   -ea:amplify_%, cmax      amplify_% (100% means no change), warns if over";
  laite <<  "\n                            cmax consecutive clipped samples";
  laite <<  "\n   -eas:amplify_%           amplify_% (100% means no change)";
  laite <<  "\n   -ec:c_rate,threshhold    compress (c_rate: -1.0 max. compress, 0.0 no";
  laite <<  "\n                            effect, >0.0 expand; doesn't affect if volume";
  laite <<  "\n                            under threshhold)";
  laite <<  "\n   -eca:peak-%, rel_time,   advanced compressor";
  laite <<  "\n    fastrate, crate         ";
  laite <<  "\n   -ef1:center_freq, width  resonant bandpass filter";
  laite <<  "\n   -ef3:cutoff_freq, reso,  resonant lowpass filter";
  laite <<  "\n        gain";
  laite <<  "\n   -efb:center_freq,width   bandpass filter";
  laite <<  "\n   -efh:cutoff_freq         highpass filter";
  laite <<  "\n   -efi:delay_in_sampl,rad  inverse comb filter";
  laite <<  "\n   -efl:cutoff_freq         lowpass filter";
  laite <<  "\n   -efr:center_freq,width   bandreject filter";
  laite <<  "\n   -efs:center_freq,width   resonator filter";
  laite <<  "\n   -enm:threshold_level_%,  noise gate, mono";
  laite <<  "\n        th_time, attack,    ([0,1], ms, ms, ms, ms)";
  laite <<  "\n        hold, release       ";
  laite <<  "\n   -epp:l_r_balance         normal pan (0 = left, 100 = right)";
  laite <<  "\n   -etd:delay_time,mode,    delay (mode: 0 = normal, ";
  laite <<  "\n        number_of_delays    1 = surround, 2 = stereo-spread)";
  laite <<  "\n        mix_%%              ";
  laite <<  "\n   -etf:delay_time          fake stereo (delay 1-40ms)";
  laite <<  "\n   -etr:reverb_time,mode,   reverb (mode: 0 = normal, ";
  laite <<  "\n       feedback_%%          1 = surround)";
  laite <<  "\n   -ev                      analyze/maximize volume (non-realtime)";
  laite <<  "\n   -ezf                     find optimal value for DC-fix";
  laite <<  "\n   -ezx:left,right          adjust DC";
// ---------------------------------------------------------------------
  laite <<  "\n";
  laite <<  "\n   -gc:beg.time, len         time crop gate (gate open for 'len' seconds ";
  laite <<  "\n                             starting from 'beg.time')";
  laite <<  "\n   -ge:othreshold%, cthold%, threshold gate (open when volume goes over";
  laite <<  "\n       volume_mode           'othreshold' and closes when it drops below"; 
  laite <<  "\n                             'cthold'. If 'value_mode' is 'rms', use";
  laite <<  "\n                             average RMS volume, otherwise use peak";
// ---------------------------------------------------------------------
  laite <<  "\n";
  laite <<  "\n   -kos:fx_param,low_range,  sine-oscillator";
  laite <<  "\n        high_rng,freq,i_phase  ";
  laite <<  "\n   -kf:fx_param, low_range,  file envelope (generic oscillator)";
  laite <<  "\n       genosc_number       ";
  laite <<  "\n   -km:fx_param, low_range,  MIDI controlled envelope";
  laite <<  "\n       high_rng, controller,";
  laite <<  "\n       channel";
  
  laite <<  "\n\n";

  return(laite.to_string());
}



