// ------------------------------------------------------------------------
// chain.cpp: Class representing abstract audio signal chain.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <string>
#include <vector>

#include "eca-error.h"
#include "eca-debug.h"
#include "samplebuffer.h"
#include "eca-chain.h"

void CHAIN::chainop_process(void) {
  gcontroller_update();
  for(chainop_sizet = 0; chainop_sizet != chainops.size(); chainop_sizet++) {
    if (enabled == true) {
      chainops[chainop_sizet]->process(&audioslot);
    }
  }
  audioslot.limit_values();
}

void CHAIN::gcontroller_update(void) {
  for(gcontroller_sizet = 0; gcontroller_sizet < gcontrollers.size(); gcontroller_sizet++) {
    gcontrollers[gcontroller_sizet]->update();
  }
}

void CHAIN::refresh_parameters(void) {
  for(chainop_sizet = 0; chainop_sizet != chainops.size(); chainop_sizet++) {
    for(int n = 0; n < chainops[chainop_sizet]->number_of_params(); n++) {
      chainops[chainop_sizet]->set_parameter(n + 1, 
					       chainops[chainop_sizet]->get_parameter(n + 1));
    }
  }
}

string CHAIN::to_string(void) const {
  string resuilt;

}

//  CHAIN& CHAIN::operator=(const CHAIN& x) { 
//    ecadebug->msg(1, "(chain) operator=");
//    if (&x != this) {
//      chainname = x.chainname;
//      chainid = x.chainid;
//      enabled = x.enabled;
//      inputid = x.inputid;
//      outputid = x.outputid;
//      //    input = x.input;
//      //    output = x.output;
//      audioslot.operator=(x.audioslot);

//      //      for (vector<CHAIN_OPERATOR*>::size_type cc = 0; cc != chainops.size(); cc++) {
//      //	chainops[cc] = x.chainops[cc];
//      //      }
//    }
//    return(*this);
//  }

//  CHAIN::CHAIN (const CHAIN& x) : audioslot(x.audioslot.length_in_samples()) {  
//    ecadebug->msg(1, "(chain) constuctor: CHAIN(const CHAIN)");
//    chainname = x.chainname;
//    chainid = x.chainid;
//    enabled = x.enabled;
//    inputid = x.inputid;
//    outputid = x.outputid;
//    //  input = x.input;
//    //  output = x.output;
//    audioslot.operator=(x.audioslot);
//    for (vector<CHAIN_OPERATOR*>::size_type cc = 0; cc != chainops.size(); cc++) {
//      chainops[cc] = x.chainops[cc];
//    }
//  }





