#ifndef _AUDIOIO_EWF_H
#define _AUDIOIO_EWF_H

#include <string>
#include "audioio.h"
#include "audioio-wave.h"
#include "samplebuffer.h"

/**
 * Ecasound Wave File (.EWF) class. Combination of ascii config
 * file and RIFF WAVE sample data file.
 * @author Kai Vehmanen
 */
class EWFFILE : public AUDIO_IO_FILE {

    WAVEFILE* wobject;

    bool wave_object_active;
    long sample_offset;

    string wavename, ewfname;
    
    void read_ewf_parameters(void);
    void write_ewf_parameters(void);
    void seek_position_in_samples(long pos);

    // attributes from .ewf data file...:

    EWFFILE& operator=(const EWFFILE& x) { return *this; }

 public:
    
    inline const AIO_PARAMS& format(void) { return(wobject->format()); }
    bool finished(void) const { return(wobject->finished()); }
        
    void read_buffer(SAMPLE_BUFFER* t);
    void write_buffer(SAMPLE_BUFFER* t);

    void open_device(void);
    void close_device(void);

 
    //    EWFFILE* new_expr(void) { return new EWFFILE(); }
    EWFFILE* clone(void) { return new EWFFILE(*this); }    
    
    EWFFILE (const string& name, const SIMODE mode, const AIO_PARAMS&
	     form, int bsize);
    ~EWFFILE(void);
};

#endif
