#ifndef _AUDIOIO_RAW_H
#define _AUDIOIO_RAW_H

#include <string>

#include "eca-fileio.h"
#include "eca-fileio-mmap.h"
#include "eca-fileio-stream.h"

class SAMPLE_BUFFER;

/**
 * Represents a raw/headerless audio file. 
 *
 * <br>Sample layout:
 *    <ul>
 *    <li> host byte-order for 16bit samples
 *    <li> for stereo samples, left channels is put first
 *    </ul>
 * @author Kai Vehmanen
 */
class RAWFILE : public AUDIO_IO_FILE {

  ECA_FILE_IO* fio;
  bool double_buffering_rep;

  RAWFILE(const RAWFILE& x) { }
  RAWFILE& operator=(const RAWFILE& x) { return *this; }

  void position_in_samples_hook(void);
  void set_length_in_bytes(void);

 public:

  void read_buffer(SAMPLE_BUFFER* t);
  void write_buffer(SAMPLE_BUFFER* t);

  void open_device(void);
  void close_device(void);
    
  RAWFILE (const string& name, const SIMODE mode, const AIO_PARAMS& format, int bsize, bool double_buffering = false);
  RAWFILE::~RAWFILE(void);
    
  RAWFILE* clone(void) { return new RAWFILE(*this); }    
};

#endif









